/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.google.common.base.Optional;
import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.agent.commonservices.timeskewhandling.AControllerTimeSkewHandler;
import com.singularity.ee.agent.configuration.channel.AgentConfigManager;
import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.configuration.identity.AgentResolverUtil;
import com.singularity.ee.agent.configuration.identity.IIdentityManager;
import com.singularity.ee.agent.configuration.impl.AgentSchedulerManager;
import com.singularity.ee.agent.configuration.impl.AgentSchedulerThreadPoolExecutorFactory;
import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.AgentResolver;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.systemagent.IMachineAgent;
import com.singularity.ee.agent.systemagent.NamedThreadFactory;
import com.singularity.ee.agent.systemagent.SystemAgent;
import com.singularity.ee.agent.systemagent.SystemAgentControllerTimeSkewHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.config.Configuration;
import com.singularity.ee.agent.systemagent.handler.OneWayAgentInitializer;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.agent.util.AgentSystemInfo;
import com.singularity.ee.agent.util.scrub.ISensitiveDataScrubber;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.transport.onewayagent.AgentTransport;
import com.singularity.ee.util.OSNameUtil;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.javaspecific.scheduler.AgentExecutorFactory;
import com.singularity.ee.util.javaspecific.scheduler.ExecutorFactory;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.keystore.AsymmetricKeysStoreWrapper;
import com.singularity.ee.util.keystore.KeyStoreReader;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.log4j.Log4JLoggerFactory;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ThreadFactory;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;

public abstract class Agent
implements IMachineAgent {
    private static final String DEFAULT_KEYSTORE_FILE_NAME = "cacerts.jks";
    private static final String CONTROLLER_HOST_INFO_XML = "controller-info.xml";
    private final String installDir;
    private final String tempDir;
    private final String tasksRootDir;
    Date date = new Date();
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected volatile IAgentScheduledExecutorService scheduler;
    protected volatile IAgentScheduledExecutorService monitorScheduler;
    private final IIdentityManager identityManager;
    private final Log4JLoggerFactory loggerFactory;
    private final ILogger logger;
    private final AgentIdentity bootStrapInfo;
    private String resolvedHostInfo;
    private final boolean orchestrationEnabled;
    private volatile RequestHandlerContext requestHandlerContext;
    private volatile AgentTransport agentTransport;
    protected volatile AgentMonitorManager agentMonitorManager;
    private volatile AgentConfigManager configManager;
    private volatile AControllerTimeSkewHandler skewHandler;
    private volatile SimpleHttpClientWrapper httpClientWrapper;
    private volatile ControllerInfo controllerInfo;
    private String accountKey;
    private final Collection<IMonitorOutputHandler> additionalOutputHandlers;
    private final String agentName;
    private volatile Thread shutDownHook;
    private ISensitiveDataScrubber sensitiveDataScrubber;
    protected ISystemAgentMetricSenderFactory senderFactory;
    private final BootstrapConfiguration bootstrapConfiguration;

    public void setSystemAgentMetricSenderFactory(ISystemAgentMetricSenderFactory senderFactory) {
        this.senderFactory = senderFactory;
    }

    public static AgentResolverUtil.AgentResolverState createDefaultAgentResolver(String installDir, ILogger logger) {
        Optional<File> globalConfigDirOpt;
        String identityConfigFile = installDir + File.separator + "conf" + File.separator + CONTROLLER_HOST_INFO_XML;
        if (!new File(identityConfigFile).exists()) {
            logger.error("Failed to find controller host info config file:" + identityConfigFile);
            System.exit(-1);
        }
        if (!(globalConfigDirOpt = Agent.getGlobalConfigDir(installDir)).isPresent()) {
            return AgentResolverUtil.getAgentResolverState((ILogger)logger, (String)identityConfigFile);
        }
        File globalConfigFile = new File((File)globalConfigDirOpt.get(), CONTROLLER_HOST_INFO_XML);
        if (!globalConfigFile.isFile()) {
            return AgentResolverUtil.getAgentResolverState((ILogger)logger, (String)identityConfigFile);
        }
        return AgentResolverUtil.getAgentResolverState((ILogger)logger, null, (String[])new String[]{identityConfigFile, globalConfigFile.getAbsolutePath()});
    }

    private static Optional<File> getGlobalConfigDir(String installDir) {
        File secondParentDir;
        Optional globalConfigDirOpt = Optional.absent();
        File firstParentDir = new File(installDir).getParentFile();
        if (firstParentDir != null && (secondParentDir = firstParentDir.getParentFile()) != null) {
            File globalConfigDir = new File(secondParentDir, "conf");
            globalConfigDirOpt = Optional.of((Object)globalConfigDir);
        }
        return globalConfigDirOpt;
    }

    public Agent(AgentResolverUtil.AgentResolverState agentResolverState, ILogger log4JLogger, @NonNull Collection<IMonitorOutputHandler> additionalOutputHandlers, @NonNull String installDir, @NonNull String agentName, @NonNull Log4JLoggerFactory log4JLoggerFactory, @NonNull BootstrapConfiguration bootstrapConfiguration, @NotNull ISensitiveDataScrubber sensitiveDataScrubber) {
        if (additionalOutputHandlers == null) {
            throw new NullPointerException("additionalOutputHandlers is marked non-null but is null");
        }
        if (installDir == null) {
            throw new NullPointerException("installDir is marked non-null but is null");
        }
        if (agentName == null) {
            throw new NullPointerException("agentName is marked non-null but is null");
        }
        if (log4JLoggerFactory == null) {
            throw new NullPointerException("log4JLoggerFactory is marked non-null but is null");
        }
        if (bootstrapConfiguration == null) {
            throw new NullPointerException("bootstrapConfiguration is marked non-null but is null");
        }
        this.additionalOutputHandlers = additionalOutputHandlers;
        this.agentName = agentName;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.sensitiveDataScrubber = sensitiveDataScrubber;
        System.out.println(" " + this.format.format(this.date) + " " + agentName + " Install Directory :" + installDir);
        this.installDir = installDir;
        OSNameUtil.setInstallDir((String)installDir);
        this.tempDir = installDir + File.separator + "tmp";
        System.out.println(" " + this.format.format(this.date) + " " + agentName + " Temp Directory :" + this.tempDir);
        try {
            new File(this.tempDir).mkdir();
        }
        catch (Exception e) {
            System.out.println(" " + this.format.format(this.date) + " Failed to create the " + agentName + " Temp Directory: " + this.tempDir + " with exception: " + e.getMessage());
            System.exit(-1);
        }
        this.tasksRootDir = installDir + File.separator + "controlchannel";
        System.out.println(" " + this.format.format(this.date) + " Tasks Root Directory :" + this.tasksRootDir);
        try {
            new File(this.tasksRootDir).mkdir();
        }
        catch (Exception e) {
            System.out.println(" " + this.format.format(this.date) + " Failed to create the Tasks Root Directory: " + this.tasksRootDir + " with exception " + e.getMessage());
            System.exit(-1);
        }
        this.loggerFactory = log4JLoggerFactory;
        if (log4JLogger == null) {
            log4JLogger = new Log4JLogger(LogManager.getLogger((String)this.getClass().getName()));
        }
        this.logger = log4JLogger;
        System.out.println(" " + this.format.format(this.date) + " Redirecting all logging statements to the configured logger");
        this.identityManager = Configuration.getConfigManager();
        String version = SystemAgent.class.getPackage().getImplementationVersion();
        this.logger.info("####################################################################################");
        this.logger.info("Agent Install Directory [" + installDir + "]");
        this.logger.info("Using Agent Version [" + version + "]");
        AgentSystemInfo.logVMInfo((ILogger)this.logger, (ISensitiveDataScrubber)sensitiveDataScrubber);
        this.logger.info(agentName + " is resolving bootstrap info....");
        Agent.createDefaultAgentValuesProperty(this.shouldCreateDefaultAgentValues());
        AgentIdentity bootStrapInfo = null;
        if (agentResolverState == null) {
            agentResolverState = Agent.createDefaultAgentResolver(installDir, this.logger);
        }
        this.orchestrationEnabled = agentResolverState.isOrchestrationEnabled();
        AgentResolver agentResolver = agentResolverState.getAgentResolver();
        try {
            boolean resolveResult = agentResolverState.isVirtualizationResolversEnabled() ? agentResolver.execute(-1L, 30000L) : agentResolver.execute(1L, 10L);
            if (!resolveResult) {
                this.logger.warn("Could not resolve agent-controller basic configuration");
                System.exit(-1);
            }
            this.controllerInfo = agentResolver.getControllerHostInfo();
            AgentAccountInfo agentAccountInfo = agentResolver.getAgentAccountInfo();
            AgentAccountInfoStore.getInstance().setAgentAccountInfo(agentAccountInfo);
            this.httpClientWrapper = this.setupHttpClientWrapper();
            bootStrapInfo = new AgentIdentity(agentResolver.getControllerHostInfo().getControllerHostName(), agentResolver.getControllerHostInfo().getControllerPort());
            this.resolvedHostInfo = agentResolver.getUniqueHostIdentifier();
        }
        catch (InterruptedException e) {
            this.logger.warn("Error executing agent resolver", (Throwable)e);
            System.exit(-1);
        }
        this.bootStrapInfo = bootStrapInfo;
        this.logger.info(agentName + " resolved bootstrap info!");
    }

    protected SimpleHttpClientWrapper setupHttpClientWrapper() {
        return AControllerRequest.setupHttpClientWrapper((ControllerInfo)this.controllerInfo, (ILogger)this.logger, (AgentAccountInfoStore.getInstance().isAccountSpecified() && this.controllerInfo.isSaaS() ? 1 : 0) != 0, (KeyStore)this.getKeyStore(), (IAgentScheduledExecutorService)this.getScheduler(), (AsymmetricKeysStoreWrapper)this.getAsymmetricKeysStore());
    }

    protected abstract AgentConfigManager createConfigManager(String var1, int var2, String var3, String var4, IAgentScheduledExecutorService var5);

    protected ILogger getLogger() {
        return this.logger;
    }

    @Override
    public final SimpleHttpClientWrapper getHttpClientWrapper() {
        return this.httpClientWrapper;
    }

    protected AgentConfigManager getConfigManager() {
        return this.configManager;
    }

    public AgentMonitorManager getAgentMonitorManager() {
        return this.agentMonitorManager;
    }

    protected AgentIdentity getBootStrapInfo() {
        return this.bootStrapInfo;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    protected ControllerInfo getControllerInfo() {
        return this.controllerInfo;
    }

    @Override
    public String getResolvedHostInfo() {
        return this.resolvedHostInfo;
    }

    public AControllerTimeSkewHandler getSkewHandler() {
        return this.skewHandler;
    }

    private static void createDefaultAgentValuesProperty(boolean value) {
        System.setProperty("appdynamics.agent.create.agent.info.if.missing", Boolean.toString(value));
    }

    @Override
    public IAgentScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setBootstrapMachineInstanceID(String machineID) {
        this.bootStrapInfo.setMachineInstanceID(machineID);
    }

    @Override
    public void start() {
        this.logger.info("Starting " + this.agentName + "....");
        try {
            this.startServices();
        }
        catch (Exception e) {
            this.logger.error("Error Starting " + this.agentName, (Throwable)e);
            System.exit(-1);
        }
        this.logger.info("Started AppDynamics " + this.agentName + " Successfully.");
        System.out.println(" " + this.format.format(this.date) + " Started AppDynamics " + this.agentName + " Successfully.");
    }

    protected void startServices() throws Exception {
        this.setupHandlerContext();
        this.skewHandler = this.setupTimeSkewHandler();
        this.requestHandlerContext.setAttribute("skew-handler", this.skewHandler);
        this.setupMonitorManager();
        this.agentTransport = (AgentTransport)new OneWayAgentInitializer(this.bootStrapInfo, this.controllerInfo, this.agentMonitorManager, this.requestHandlerContext, this.orchestrationEnabled, this.logger, Boolean.getBoolean("orchestration-check-override")).setup();
        this.setupConfigurationManager();
    }

    protected AControllerTimeSkewHandler setupTimeSkewHandler() throws Exception {
        boolean isServiceDisabledByDefault = this.areServicesDisabledOnStartup();
        SystemAgentControllerTimeSkewHandler skewHandler = new SystemAgentControllerTimeSkewHandler(new Log4JLogger(LogManager.getLogger((String)"com.singularity.ControllerTimeSkewHandler")), this.bootStrapInfo.getControllerHost(), this.bootStrapInfo.getControllerPort(), this.bootStrapInfo.getMachineInstanceID(), isServiceDisabledByDefault);
        skewHandler.run();
        this.scheduler.scheduleWithFixedDelay((IAgentRunnable)skewHandler, 300000L, 300000L, AgentTimeUnit.MILLISECONDS);
        return skewHandler;
    }

    private void setupConfigurationManager() {
        String controllerHost = this.bootStrapInfo.getControllerHost();
        int controllerPort = this.bootStrapInfo.getControllerPort();
        String machineInstanceID = this.bootStrapInfo.getMachineInstanceID();
        String agentID = this.bootStrapInfo.getAgentID();
        IAgentScheduledThreadPoolExecutor agentGlobalScheduler = AgentSchedulerManager.getAgentGlobalScheduler();
        this.configManager = this.createConfigManager(controllerHost, controllerPort, machineInstanceID, agentID, (IAgentScheduledExecutorService)agentGlobalScheduler);
        this.logger.info("Configuration manager successfully configured");
    }

    protected void startScheduler() {
        int corePoolSize = Integer.getInteger("machine.agent.scheduler.pool.size", 2);
        this.logger.info("Creating machine agent scheduler, pool size: " + corePoolSize);
        NamedThreadFactory threadFactory = new NamedThreadFactory("Agent-Scheduler");
        this.scheduler = ExecutorFactory.newScheduledThreadPool((int)corePoolSize, (ThreadFactory)threadFactory, (ILogger)this.logger);
        corePoolSize = Integer.getInteger("machine.agent.monitor.scheduler.pool.size", 4);
        this.logger.info("Creating machine agent monitor scheduler, pool size: " + corePoolSize);
        threadFactory = new NamedThreadFactory("Agent-Monitor-Scheduler");
        this.monitorScheduler = ExecutorFactory.newScheduledThreadPool((int)corePoolSize, (ThreadFactory)threadFactory, (ILogger)this.logger);
        AgentExecutorFactory agentExecutorFactory = new AgentExecutorFactory();
        AgentSchedulerThreadPoolExecutorFactory schedulerThreadPoolExecutorFactory = new AgentSchedulerThreadPoolExecutorFactory(agentExecutorFactory);
        AgentSchedulerManager.init((ILogger)this.logger, (AgentSchedulerThreadPoolExecutorFactory)schedulerThreadPoolExecutorFactory);
        this.logger.info("Started Agent Schedulers");
    }

    private void setupHandlerContext() throws Exception {
        this.requestHandlerContext = new RequestHandlerContext();
        this.requestHandlerContext.setAttribute("Agent-Install-Dir", this.installDir);
        this.requestHandlerContext.setAttribute("Agent-Scheduler", this.scheduler);
        this.requestHandlerContext.setAttribute("Agent-Monitor-Scheduler", this.monitorScheduler);
        this.requestHandlerContext.setAttribute("Config-Manager", this.identityManager);
        this.requestHandlerContext.setAttribute("Agent-Identity", this.bootStrapInfo);
        this.requestHandlerContext.setAttribute("Agent-Logger-Factory", this.loggerFactory);
        this.requestHandlerContext.setAttribute("Agent-Temp-Dir", this.tempDir);
        this.requestHandlerContext.setAttribute("Agent-Tasks-Root-Dir", this.tasksRootDir);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Set up request handler context ->" + String.valueOf(this.requestHandlerContext.getAttributeMap()));
        }
    }

    private void setupMonitorManager() throws Exception {
        this.agentMonitorManager = new AgentMonitorManager(this.bootStrapInfo.getMachineInstanceID(), this.bootStrapInfo.getControllerHost(), this.bootStrapInfo.getControllerPort(), this.requestHandlerContext, this, this.additionalOutputHandlers, this.senderFactory);
        this.logger.info("Set up agent monitor manager");
    }

    @Override
    public void stop() {
        this.logger.info("Stopping " + this.agentName + "....");
        if (this.agentTransport != null) {
            try {
                this.logger.info("Shutting down agent transport");
                this.agentTransport.shutdown();
                this.logger.info("Stopped agent transport");
                this.agentTransport = null;
            }
            catch (Exception e) {
                this.logger.error("Error stopping agent transport", (Throwable)e);
            }
        }
        try {
            this.logger.info("Shutting down agent scheduler manager");
            AgentSchedulerManager.shutdownNow();
            this.logger.info("Shutting down agent scheduler manager");
        }
        catch (Exception e) {
            this.logger.error("Error stopping agent scheduler manager", (Throwable)e);
        }
        if (this.agentMonitorManager != null) {
            try {
                this.logger.info("Shutting down agent monitor manager");
                this.agentMonitorManager.shutdown();
                this.logger.info("Stopped agent monitor manager");
                this.agentMonitorManager = null;
            }
            catch (Exception e) {
                this.logger.error("Error stopping agent monitor manager", (Throwable)e);
            }
        }
        this.stopScheduler();
        this.stopMonitorScheduler();
        if (this.shutDownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (IllegalStateException e) {
                this.logger.trace("Already shutting down. Can't remove shutdown hook.");
            }
        }
        this.logger.info(this.agentName + " Stopped!");
    }

    private synchronized void stopMonitorScheduler() {
        if (this.monitorScheduler != null) {
            this.logger.info("Shutting down monitor scheduler");
            try {
                this.monitorScheduler.shutdownNow();
            }
            catch (Exception e) {
                this.logger.warn("Failed to shut down monitor scheduler.", (Throwable)e);
            }
            this.logger.debug("Stopped monitor scheduler");
            this.monitorScheduler = null;
        }
    }

    protected synchronized void stopScheduler() {
        if (this.scheduler != null) {
            this.logger.info("Shutting down scheduler");
            try {
                this.scheduler.shutdownNow();
            }
            catch (Exception e) {
                this.logger.warn("Error stopping scheduler", (Throwable)e);
            }
            this.logger.info("Stopped scheduler");
            this.scheduler = null;
        }
    }

    protected KeyStore getKeyStore() {
        String configDir = this.installDir + File.separator + "conf";
        try {
            if (this.controllerInfo.isSslEnabled()) {
                String clearTextKeystorePassword = this.controllerInfo.getKeystorePassword();
                return this.getKeyStore(this.controllerInfo.getResolvedKeystoreFileName(), configDir, clearTextKeystorePassword);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error executing getKeyStore()", (Throwable)e);
        }
        return this.getKeyStore(this.controllerInfo.getResolvedKeystoreFileName(), configDir);
    }

    private KeyStore getKeyStore(String fileName, String configDir) {
        return this.getKeyStore(fileName, configDir, null);
    }

    private KeyStore getKeyStore(String fileName, String configDir, String password) {
        if (StringOperations.isEmpty((String)fileName)) {
            fileName = DEFAULT_KEYSTORE_FILE_NAME;
        }
        fileName = configDir + File.separator + (String)fileName;
        KeyStore returnValue = null;
        try {
            returnValue = KeyStoreReader.readKeyStoreFile((String)fileName, (String)password);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Keystore file " + (String)fileName + " was successfully read");
            }
        }
        catch (FileNotFoundException e) {
            this.logger.info("Keystore file " + (String)fileName + " was not found");
        }
        catch (Throwable t) {
            this.logger.error("Exception: " + t.toString() + " caught trying to read keystore file", t);
        }
        return returnValue;
    }

    protected AsymmetricKeysStoreWrapper getAsymmetricKeysStore() {
        String configDir = this.installDir + File.separator + "conf";
        AsymmetricKeysStoreWrapper asymmetricKeysStore = null;
        if (this.controllerInfo.isSslClientAuthEnabled()) {
            try {
                asymmetricKeysStore = new AsymmetricKeysStoreWrapper(configDir, this.controllerInfo.getAsymmetricKeysStoreFilename(), this.controllerInfo.getAsymmetricKeysStorePassword(), this.controllerInfo.getAsymmetricKeyPassword(), this.controllerInfo.getAsymmetricKeyAlias());
            }
            catch (Exception allExceptions) {
                throw new IllegalStateException("Failed to initialize AsymmetricKeysStore for ClientAuthentication. ", allExceptions);
            }
        }
        return asymmetricKeysStore;
    }

    public void init() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new Thread(){

                @Override
                public void run() {
                    Agent.this.stop();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
        this.startScheduler();
    }

    protected boolean shouldCreateDefaultAgentValues() {
        return false;
    }

    @Override
    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    @Override
    public String getAccountKey() {
        return this.accountKey;
    }

    public void switchDisabled(boolean isDisabled) {
        this.logger.info("Agent is now: [" + (isDisabled ? "disabled" : "enabled") + "].");
        SystemAgentControllerTimeSkewHandler skewHandler = (SystemAgentControllerTimeSkewHandler)this.getSkewHandler();
        skewHandler.switchDisabled(isDisabled);
    }

    @Override
    public boolean areServicesDisabledOnStartup() {
        return false;
    }

    @Override
    @Generated
    public BootstrapConfiguration getBootstrapConfiguration() {
        return this.bootstrapConfiguration;
    }
}

