/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.tags;

import com.appdynamics.agent.sim.tags.DefaultMachineTags;
import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.InitialMachineTags;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class MachineTagsProvider
implements Provider<MachineTags> {
    private final Set<Map<MachineTagMapName, SetMultimap<String, String>>> initialTags;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    @Inject
    public MachineTagsProvider(@InitialMachineTags @NonNull Set<Map<MachineTagMapName, SetMultimap<String, String>>> initialTags, GlobalTagsConfigsDecider globalTagsConfigsDecider) {
        if (initialTags == null) {
            throw new NullPointerException("initialTags is marked non-null but is null");
        }
        this.initialTags = initialTags;
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
    }

    public MachineTags get() {
        Map<MachineTagMapName, SetMultimap<String, String>> combinedMachineTagMap = this.combineMachineTagMapsFromInitialTags();
        return new DefaultMachineTags(combinedMachineTagMap, this.globalTagsConfigsDecider);
    }

    @VisibleForTesting
    Map<MachineTagMapName, SetMultimap<String, String>> combineMachineTagMapsFromInitialTags() {
        ConcurrentHashMap<MachineTagMapName, SetMultimap<String, String>> mapOfMachineTagMap = new ConcurrentHashMap<MachineTagMapName, SetMultimap<String, String>>();
        for (Map<MachineTagMapName, SetMultimap<String, String>> machineTagMap : this.initialTags) {
            mapOfMachineTagMap.putAll(machineTagMap);
        }
        return mapOfMachineTagMap;
    }
}

