/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.tags;

import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTagsConfigsDecider
implements TagsConfigsDecider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalTagsConfigsDecider.class);
    private static final int DEFAULT_MAX_TAGS_PER_MACHINE = 50;
    private final Provider<Features> features;
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;

    @Inject
    public GlobalTagsConfigsDecider(@NonNull Provider<Features> features, @NonNull Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        if (features == null) {
            throw new NullPointerException("features is marked non-null but is null");
        }
        if (controllerServerMonitoringConfigProvider == null) {
            throw new NullPointerException("controllerServerMonitoringConfigProvider is marked non-null but is null");
        }
        this.features = features;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    @Override
    public boolean isTagEnabled() {
        boolean tagEnabled = false;
        if (this.features.get() != null && this.controllerServerMonitoringConfigProvider.get() != null) {
            boolean globalTagsEnabled = ((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()).isTagsEnabled();
            boolean simEnabled = ((Features)this.features.get()).has("sim");
            tagEnabled = simEnabled && globalTagsEnabled;
        }
        log.debug("Global tags enabled: " + tagEnabled);
        return tagEnabled;
    }

    public int getMaxTagsPerMachine() {
        Optional controllerServerMonitoringConfig = Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()));
        if (!controllerServerMonitoringConfig.isPresent()) {
            return this.getDefaultMaxTagsPerMachine();
        }
        Optional maxTagsPerMachine = ((AgentMonitorConfig)controllerServerMonitoringConfig.get()).getMaxTagsPerMachine();
        return (Integer)maxTagsPerMachine.or((Object)this.getDefaultMaxTagsPerMachine());
    }

    public boolean isTagWithinLengthLimit(String tagKey, String tagValue) {
        return tagKey.length() <= this.getTagKeyLengthLimit() && tagValue.length() <= this.getTagValueLengthLimit();
    }

    @VisibleForTesting
    int getDefaultMaxTagsPerMachine() {
        return 50;
    }

    @VisibleForTesting
    int getTagKeyLengthLimit() {
        return 255;
    }

    @VisibleForTesting
    int getTagValueLengthLimit() {
        return 255;
    }
}

