/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMachineTags
implements MachineTags {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMachineTags.class);
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private final Map<MachineTagMapName, SetMultimap<String, String>> mapOfMachineTagMap;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    DefaultMachineTags(Map<MachineTagMapName, SetMultimap<String, String>> mapOfMachineTagMap, GlobalTagsConfigsDecider globalTagsConfigsDecider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.mapOfMachineTagMap = this.filterMapOfTagMap(mapOfMachineTagMap);
    }

    @Override
    public void updateTagMap(MachineTagMapName name, SetMultimap<String, String> machineTagMap) {
        this.mapOfMachineTagMap.put(name, this.filterMapOfTag(name, machineTagMap));
    }

    @Override
    public SetMultimap<String, String> toMap() {
        if (this.globalTagsConfigsDecider.isTagEnabled()) {
            int currentTagsCount = 0;
            int maxTagsLimit = this.globalTagsConfigsDecider.getMaxTagsPerMachine();
            ImmutableSetMultimap.Builder allMachineTagMapBuilder = ImmutableSetMultimap.builder();
            for (SetMultimap<String, String> machineTagMap : this.mapOfMachineTagMap.values()) {
                if (machineTagMap.size() <= maxTagsLimit - currentTagsCount) {
                    allMachineTagMapBuilder.putAll(machineTagMap);
                    currentTagsCount += machineTagMap.size();
                    continue;
                }
                for (Map.Entry tag : machineTagMap.entries()) {
                    if (maxTagsLimit - currentTagsCount <= 0) break;
                    allMachineTagMapBuilder.put((Object)((String)tag.getKey()), (Object)((String)tag.getValue()));
                    ++currentTagsCount;
                }
                log.debug("Per machine tag limit hit. Dropping arbitrary tags to stay within the limit.");
                break;
            }
            return allMachineTagMapBuilder.build();
        }
        return EMPTY_TAG_MAP;
    }

    private Map<MachineTagMapName, SetMultimap<String, String>> filterMapOfTagMap(Map<MachineTagMapName, SetMultimap<String, String>> originalMap) {
        HashMap<MachineTagMapName, SetMultimap<String, String>> filterMapOfMachineTagMap = new HashMap<MachineTagMapName, SetMultimap<String, String>>();
        for (Map.Entry<MachineTagMapName, SetMultimap<String, String>> machineTagMapEntry : originalMap.entrySet()) {
            MachineTagMapName tagMapName = machineTagMapEntry.getKey();
            SetMultimap<String, String> tagMap = machineTagMapEntry.getValue();
            filterMapOfMachineTagMap.put(tagMapName, this.filterMapOfTag(tagMapName, tagMap));
        }
        return filterMapOfMachineTagMap;
    }

    private SetMultimap<String, String> filterMapOfTag(MachineTagMapName name, SetMultimap<String, String> originalMap) {
        SetMultimap filteredMap;
        Predicate<Map.Entry<String, String>> tagLengthFilter = new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> tagEntry) {
                return DefaultMachineTags.this.globalTagsConfigsDecider.isTagWithinLengthLimit(tagEntry.getKey(), tagEntry.getValue());
            }
        };
        SetMultimap<String, String> prefixTagMap = originalMap;
        if (name != MachineTagMapName.SMART_AGENT_INTEGRATION_TAG_MAP) {
            prefixTagMap = this.addIntegrationPrefix(name, originalMap);
        }
        if (!(filteredMap = Multimaps.filterEntries(prefixTagMap, (Predicate)tagLengthFilter)).equals(prefixTagMap)) {
            log.debug("Dropping some tag(s) in {} due to tag exceeding length limit", (Object)name);
        }
        return filteredMap;
    }

    private SetMultimap<String, String> addIntegrationPrefix(MachineTagMapName name, SetMultimap<String, String> originalMap) {
        HashMultimap prefixTagMap = originalMap;
        if (name.getIntegrationName() != null) {
            prefixTagMap = HashMultimap.create();
            String prefix = name.getIntegrationName();
            for (Map.Entry tag : originalMap.entries()) {
                prefixTagMap.put((Object)(prefix + "\u0000" + (String)tag.getKey()), (Object)((String)tag.getValue()));
            }
        }
        return prefixTagMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMachineTags)) {
            return false;
        }
        DefaultMachineTags other = (DefaultMachineTags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<MachineTagMapName, SetMultimap<String, String>> this$mapOfMachineTagMap = this.mapOfMachineTagMap;
        Map<MachineTagMapName, SetMultimap<String, String>> other$mapOfMachineTagMap = other.mapOfMachineTagMap;
        if (this$mapOfMachineTagMap == null ? other$mapOfMachineTagMap != null : !((Object)this$mapOfMachineTagMap).equals(other$mapOfMachineTagMap)) {
            return false;
        }
        GlobalTagsConfigsDecider this$globalTagsConfigsDecider = this.globalTagsConfigsDecider;
        GlobalTagsConfigsDecider other$globalTagsConfigsDecider = other.globalTagsConfigsDecider;
        return !(this$globalTagsConfigsDecider == null ? other$globalTagsConfigsDecider != null : !this$globalTagsConfigsDecider.equals(other$globalTagsConfigsDecider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultMachineTags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<MachineTagMapName, SetMultimap<String, String>> $mapOfMachineTagMap = this.mapOfMachineTagMap;
        result = result * 59 + ($mapOfMachineTagMap == null ? 43 : ((Object)$mapOfMachineTagMap).hashCode());
        GlobalTagsConfigsDecider $globalTagsConfigsDecider = this.globalTagsConfigsDecider;
        result = result * 59 + ($globalTagsConfigsDecider == null ? 43 : $globalTagsConfigsDecider.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultMachineTags(mapOfMachineTagMap=" + String.valueOf(this.mapOfMachineTagMap) + ", globalTagsConfigsDecider=" + String.valueOf(this.globalTagsConfigsDecider) + ")";
    }
}

