/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.factory;

import com.appdynamics.agent.sim.sam.SamExtension;
import com.appdynamics.agent.sim.sam.validator.factory.RuleFactory;
import com.appdynamics.agent.sim.sam.validator.rules.NotRule;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.sim.common.rest.sam.SamRuleOperatorDto;
import com.appdynamics.sim.common.rest.sam.SamValidationRuleDto;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotRuleFactory
implements RuleFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotRuleFactory.class);
    private final Map<SamRuleOperatorDto, RuleFactory> ruleFactoryMap;
    private final Map<SamRuleOperatorDto, SamRuleOperatorDto> inverseOperatorMap;

    @Inject
    NotRuleFactory(Map<SamRuleOperatorDto, RuleFactory> ruleFactoryMap, @SamExtension Map<SamRuleOperatorDto, SamRuleOperatorDto> inverseOperatorMap) {
        this.ruleFactoryMap = ruleFactoryMap;
        this.inverseOperatorMap = inverseOperatorMap;
    }

    @Override
    public Rule create(SamValidationRuleDto validationRuleDto) {
        SamRuleOperatorDto operator = validationRuleDto.getOperator();
        SamRuleOperatorDto inverseOperatorDto = this.inverseOperatorMap.get(operator);
        if (inverseOperatorDto == null) {
            throw new UnsupportedOperationException("Unable to create NotRule for " + String.valueOf(operator) + "because inverse operator is not defined");
        }
        Rule inverseRule = this.ruleFactoryMap.get(inverseOperatorDto).create(validationRuleDto);
        return new NotRule(inverseRule);
    }
}

