/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator;

import com.appdynamics.agent.sim.sam.validator.RuleChainFactory;
import com.appdynamics.agent.sim.sam.validator.factory.RuleFactory;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.sim.common.rest.sam.SamRuleOperatorDto;
import com.appdynamics.sim.common.rest.sam.SamValidationRuleDto;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DefaultRuleChainFactory
implements RuleChainFactory {
    private final Map<SamRuleOperatorDto, RuleFactory> ruleFactoryMap;

    @Inject
    DefaultRuleChainFactory(Map<SamRuleOperatorDto, RuleFactory> ruleFactoryMap) {
        this.ruleFactoryMap = ruleFactoryMap;
    }

    @Override
    public List<Rule> makeRulesFrom(List<SamValidationRuleDto> validationRules) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>(validationRules.size());
        for (SamValidationRuleDto validationRule : validationRules) {
            RuleFactory ruleFactory = this.ruleFactoryMap.get(validationRule.getOperator());
            if (ruleFactory == null) {
                throw new IllegalArgumentException("Unable to create the rule for : " + String.valueOf(validationRule.getOperator()));
            }
            ruleList.add(ruleFactory.create(validationRule));
        }
        return ruleList;
    }
}

