/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.sam.SamCheckerTaskRegistry;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpFullDto;
import com.appdynamics.sim.common.rest.sam.SamTargetsAgentService;
import com.appdynamics.sim.common.rest.sam.SamTargetsDto;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceAvailabilityMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceAvailabilityMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    private final String hostId;
    private final SamTargetsAgentService targetsAgentService;
    private final SamCheckerTaskRegistry samCheckerTaskRegistry;
    private final Scheduler scheduler;
    private final BootstrapConfiguration bootstrapConfig;
    private volatile String configTimestampSignature;
    private volatile ScheduledFuture<?> future;

    @Inject
    ServiceAvailabilityMonitor(@HostId String hostId, SamTargetsAgentService targetsAgentService, SamCheckerTaskRegistry samCheckerTaskRegistry, Scheduler scheduler, BootstrapConfiguration bootstrapConfig) {
        this.hostId = hostId;
        this.targetsAgentService = targetsAgentService;
        this.samCheckerTaskRegistry = samCheckerTaskRegistry;
        this.scheduler = scheduler;
        this.bootstrapConfig = bootstrapConfig;
        this.configTimestampSignature = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startAvailabilityMonitoring() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                this.future = this.scheduler.scheduleWithFixedDelay((Runnable)this, this.bootstrapConfig.getSamConfigUpdateIntervalMillis().longValue(), this.bootstrapConfig.getSamConfigUpdateIntervalMillis().longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopAvailabilityMonitoring() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.samCheckerTaskRegistry.stopAll();
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                log.debug("Updating service availability configuration...");
                SamTargetsDto targets = this.targetsAgentService.getSamTargetsOfMachine(this.hostId, this.configTimestampSignature);
                if (!targets.getSamTargets().isPresent()) {
                    return;
                }
                this.configTimestampSignature = (String)targets.getConfigSignature().get();
                this.samCheckerTaskRegistry.stopAll();
                for (SamTargetHttpFullDto target : (List)targets.getSamTargets().get()) {
                    this.samCheckerTaskRegistry.addTaskFromConfig(target);
                }
            }
            catch (Exception e) {
                log.warn("Could not schedule service availability checking tasks.", (Throwable)e);
            }
        }
    }
}

