/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.registration;

import com.appdynamics.agent.sim.assembler.GlobalAssembly;
import com.appdynamics.agent.sim.configuration.AgentConfig;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineHierarchy;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineName;
import com.appdynamics.agent.sim.dmm.SimMachineIdSupplier;
import com.appdynamics.agent.sim.logOperations.LogCaptureConstants;
import com.appdynamics.agent.sim.logOperations.LogCaptureHandler;
import com.appdynamics.agent.sim.logOperations.OperationInfo;
import com.appdynamics.agent.sim.metadata.MachineMetadata;
import com.appdynamics.agent.sim.registration.AgentConfigFactory;
import com.appdynamics.agent.sim.registration.IRegistrationTaskManager;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.agent.sim.tags.TagConstants;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationRequest;
import com.appdynamics.sim.common.biz.shared.machines.AssemblyDescriptors;
import com.appdynamics.sim.common.rest.machines.GenericConfig;
import com.appdynamics.sim.common.rest.machines.OperationResult;
import com.appdynamics.sim.common.rest.machines.SimMachineFullDto;
import com.appdynamics.sim.common.rest.machines.SimMachineMinimalDto;
import com.appdynamics.sim.common.rest.machines.SimMachineTypeDto;
import com.appdynamics.sim.common.rest.machines.SimMachinesAgentService;
import com.appdynamics.sim.common.rest.metadata.SimMetadataAgentService;
import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.rest.client.NonRestException;
import com.appdynamics.voltron.rest.utils.RestException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.singularity.ee.controller.api.dto.sim.simagentoperations.LogHandlerParameters;
import com.singularity.ee.controller.api.dto.sim.simagentoperations.LoggerLevel;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationTask
implements Runnable,
IRegistrationTaskManager,
LogCaptureConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistrationTask.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final boolean OMIT_STACK_TRACE = true;
    private final BootstrapConfiguration bootstrapConfig;
    private final SimMachinesAgentService simMachinesService;
    private final SimMetadataAgentService simMetadataService;
    private final String hostId;
    private final String machineName;
    private final List<String> machineHierarchy;
    private final MachineProperties machineProperties;
    private final MachineTags machineTags;
    private final MachineMetadata machineMetadata;
    private final ScheduledExecutorService executorService;
    private final ConfigurationWriter configurationWriter;
    private final ObjectMapper objectMapper;
    private final AgentConfigFactory agentConfigFactory;
    private final GlobalAssembly globalAssembly;
    private ScheduledFuture<?> future;
    private GenericConfig prevConfig;
    @NonNull
    private GenericConfig agentConfig;
    private boolean isFirstRegistration;
    private boolean useNewMetadataEndpoint = true;
    private static final String ACCOUNT_KEY_REGEX = "accountKey=[A-Za-z0-9-]+";
    private static final String ACCOUNT_KEY_MASK = "accountKey=****";
    private final SimMachineIdSupplier simMachineIdSupplier;
    private final AtomicLong lastSuccessfulRegistrationTimestamp = new AtomicLong(0L);
    private LogCaptureHandler logCaptureHandler;
    private ScheduledFuture reaperFuture;

    @Inject
    public RegistrationTask(BootstrapConfiguration bootstrapConfig, SimMachinesAgentService simMachinesService, SimMetadataAgentService simMetadataService, @HostId String hostId, @MachineName String machineName, @MachineHierarchy List<String> machineHierarchy, MachineProperties machineProperties, MachineTags machineTags, MachineMetadata machineMetadata, @SystemScheduler ScheduledExecutorService executorService, ConfigurationWriter configurationWriter, @AgentConfig ObjectMapper objectMapper, SimMachineIdSupplier simMachineIdSupplier, GlobalAssembly globalAssembly, AgentConfigFactory agentConfigFactory) {
        this.bootstrapConfig = bootstrapConfig;
        this.simMachinesService = simMachinesService;
        this.simMetadataService = simMetadataService;
        this.hostId = hostId;
        this.machineName = machineName;
        this.machineHierarchy = machineHierarchy;
        this.machineProperties = machineProperties;
        this.machineTags = machineTags;
        this.machineMetadata = machineMetadata;
        this.executorService = executorService;
        this.configurationWriter = configurationWriter;
        this.objectMapper = objectMapper;
        this.isFirstRegistration = true;
        this.agentConfigFactory = agentConfigFactory;
        this.agentConfig = this.agentConfigFactory.createAgentConfig(this.isFirstRegistration, machineProperties.toMap(), this.getType());
        this.simMachineIdSupplier = simMachineIdSupplier;
        this.globalAssembly = globalAssembly;
        this.logCaptureHandler = new LogCaptureHandler(bootstrapConfig.getControllerHost(), bootstrapConfig.getControllerPort(), bootstrapConfig.getHostId(), null, (String)(StringUtils.isNotBlank((CharSequence)bootstrapConfig.getAgentRuntimeDir()) ? bootstrapConfig.getAgentRuntimeDir() : (String)machineProperties.toMap().get("AppDynamics|Agent|Install Directory") + "/logs"), (String)machineProperties.toMap().get("AppDynamics|Agent|Install Directory"));
        this.reaperFuture = this.scheduleReaperThread(60000, 60000);
    }

    public ScheduledFuture scheduleReaperThread(int reaperInitialDelay, int reaperInterval) {
        return this.executorService.scheduleAtFixedRate((Runnable)((Object)new Reaper()), reaperInitialDelay, reaperInterval, TimeUnit.MILLISECONDS);
    }

    public void cancelReaperThread() {
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
            this.reaperFuture = null;
        }
    }

    @Override
    public void run() {
        try {
            List<String> machineHierarchyToUse = this.machineHierarchy;
            if (!this.bootstrapConfig.getClusterName().isEmpty()) {
                ArrayList<String> mutableMachineHierarchy = new ArrayList<String>(this.machineHierarchy);
                this.updateMachineHierarchy(mutableMachineHierarchy);
                machineHierarchyToUse = mutableMachineHierarchy;
            }
            SimMachineMinimalDto input = new SimMachineMinimalDto(this.hostId, this.machineName, machineHierarchyToUse, this.machineProperties.toMap(), Multimaps.asMap(this.machineTags.toMap()), this.agentConfig);
            log.debug("Running registration task");
            log.trace("Running registration task with input {}", (Object)input);
            SimMachineFullDto response = this.simMachinesService.registerMachine(input);
            log.debug("Got registration response {}", (Object)response.getId());
            if (this.isFirstRegistration) {
                log.info("Machine Agent registered successfully with machineID: {} and hostID: {}", (Object)response.getId(), (Object)response.getHostId());
            }
            this.updateLastSuccessfulRegistrationTimestamp();
            this.simMachineIdSupplier.set(response.getId());
            GenericConfig controllerConfig = response.getControllerConfig();
            Optional assemblyDescriptors = this.agentConfig.of("_descriptorConfig", AssemblyDescriptors.class);
            if (assemblyDescriptors.isPresent()) {
                controllerConfig.getRawConfig().remove("_descriptorConfig");
                this.globalAssembly.setControllerAssembly((AssemblyDescriptors)assemblyDescriptors.get());
            }
            for (Map.Entry<String, Object> entry : controllerConfig.getRawConfig().entrySet()) {
                Object prevVal = null;
                if (this.prevConfig != null) {
                    String configName = (String)entry.getKey();
                    if (!this.configurationWriter.isAnyListenerForConfig(configName)) {
                        log.trace("There is no listeners found for this config {}", (Object)configName);
                        continue;
                    }
                    prevVal = this.prevConfig.getRawConfig().get(entry.getKey());
                }
                if (prevVal == null || !prevVal.equals(entry.getValue())) {
                    this.logWritingConfig(entry);
                    try {
                        this.configurationWriter.writeConfiguration(entry.getKey(), entry.getValue());
                        continue;
                    }
                    catch (ConfigurationException | IOException e) {
                        log.warn("Could not write configuration " + String.valueOf(controllerConfig) + " into the config system.", (Object)e.getMessage());
                        log.error("Could not write configuration into the config system:{}", e);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.warn("Registration task interrupted");
                        log.error("Registration task interrupted:{}", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                log.trace("Got the same config {}", entry);
            }
            if (this.isFirstRegistration) {
                this.isFirstRegistration = false;
                this.agentConfig = this.agentConfigFactory.createAgentConfig(this.isFirstRegistration, this.machineProperties.toMap(), this.getType());
            }
            this.prevConfig = this.extractNonTransientFeatures(controllerConfig);
            try {
                ArrayList arrayList = (ArrayList)controllerConfig.getRawConfig().get("LogOperation");
                if (arrayList != null) {
                    for (Object item : arrayList) {
                        LinkedHashMap innerMap = (LinkedHashMap)item;
                        log.debug("LogOperation located in controller config response with operationId key: " + String.valueOf(innerMap));
                        if (innerMap != null) {
                            log.debug("Uploading logs for Operation ID: " + innerMap.get("operationId").toString());
                        }
                        this.handleCaptureAgentLogs(innerMap);
                    }
                } else {
                    log.trace("No LogOperation Task located in controller config response.");
                }
            }
            catch (Exception e) {
                log.debug("Encountered error processing Log Operations Config");
            }
            if (this.simMachineIdSupplier.get().isPresent()) {
                this.sendMachineMetadata((Long)this.simMachineIdSupplier.get().get());
            }
        }
        catch (RestException r) {
            log.warn("Encountered error during registration. Will retry in " + this.bootstrapConfig.getRegistrationPeriodSeconds() + " seconds.\n{}", (Object)r.getMessage(true));
            log.error("Encountered error during registration:{}", (Throwable)r);
        }
        catch (RuntimeException e) {
            log.warn("Encountered error during registration. Will retry in " + this.bootstrapConfig.getRegistrationPeriodSeconds() + " seconds.");
            log.error("Encountered error during registration: {}", (Throwable)e);
        }
    }

    private void logWritingConfig(Map.Entry<String, Object> entry) {
        if (log.isDebugEnabled()) {
            AbstractMap.SimpleEntry<String, Object> logEntry = new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), entry.getValue());
            if (entry.getKey().equals("_agentRegistrationConfig")) {
                logEntry.setValue(entry.getValue().toString().replaceAll(ACCOUNT_KEY_REGEX, ACCOUNT_KEY_MASK));
            }
            log.debug("Writing config {} into system.", logEntry);
        }
    }

    @Override
    public boolean isScheduled() {
        return this.future != null && !this.future.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartRegistrationLifecycle() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("restartRegistrationLifecycle is being called");
            this.lifecycleStop();
            this.lifecycleStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void lifecycleStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("lifecycleStart is being called");
            if (this.future == null) {
                this.future = this.executorService.scheduleAtFixedRate(this, 0L, this.bootstrapConfig.getRegistrationPeriodSeconds(), TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void lifecycleStop() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("lifecycleStop is being called");
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public boolean isRegistrationResilienceEnabled() {
        return this.bootstrapConfig.getRegistrationResilienceEnabled();
    }

    @VisibleForTesting
    AgentRegistrationRequest fromMachineProperties() {
        String appName;
        Map machinePropertiesMap = this.machineProperties.toMap();
        AgentRegistrationRequest.Builder builder = AgentRegistrationRequest.builder((String)((String)machinePropertiesMap.get("AppDynamics|Agent|Machine Info")), (String)((String)machinePropertiesMap.get("AppDynamics|Agent|JVM Info")), (String)((String)machinePropertiesMap.get("AppDynamics|Agent|Install Directory")), (String)((String)machinePropertiesMap.get("AppDynamics|Agent|Agent version"))).tierName(this.bootstrapConfig.getTierName()).nodeName(this.bootstrapConfig.getNodeName()).autoRegisterAgent(this.bootstrapConfig.getCreateNodeIfAbsent().booleanValue());
        boolean isSapMachineFlag = this.bootstrapConfig.getSapMachine();
        if (isSapMachineFlag) {
            builder.sapMachine(Boolean.valueOf(isSapMachineFlag));
        }
        if ((appName = this.bootstrapConfig.getApplicationName()) != null) {
            builder.applicationNames(Collections.singleton(appName));
        }
        return builder.build();
    }

    @VisibleForTesting
    void sendMachineMetadata(long machineId) {
        GenericConfig config = new GenericConfig(this.machineMetadata.toMap(), this.objectMapper);
        log.trace("Sending machine metadata: {}", (Object)config);
        if (this.useNewMetadataEndpoint) {
            try {
                log.trace("Sending data to a new metadata endpoint");
                OperationResult operationResult = this.simMetadataService.upsertMachineMetadata(machineId, config);
                log.trace("Machine metadata upsert result: {}", (Object)operationResult);
            }
            catch (NonRestException e) {
                log.trace("Observed REST exception", (Throwable)e);
                log.info("New metadata endpoint is not available for your controller. Downgrading to old one.");
                this.useNewMetadataEndpoint = false;
            }
        }
        if (!this.useNewMetadataEndpoint) {
            log.trace("Sending data to an old metadata endpoint");
            this.simMetadataService.updateMachineMetadata(machineId, config);
            log.trace("Successful upload of metadata");
        }
    }

    SimMachineTypeDto getType() {
        if (this.bootstrapConfig.getDockerEnabled().booleanValue() || this.bootstrapConfig.getContainerdEnabled().booleanValue()) {
            return SimMachineTypeDto.CONTAINER_AWARE;
        }
        return SimMachineTypeDto.PHYSICAL;
    }

    @VisibleForTesting
    GenericConfig extractNonTransientFeatures(GenericConfig currentConfig) {
        LinkedHashMap entriesToSave = new LinkedHashMap();
        for (Map.Entry entry : currentConfig.getRawConfig().entrySet()) {
            if ("_transientFeatures".equals(entry.getKey())) continue;
            entriesToSave.put((String)entry.getKey(), entry.getValue());
        }
        return new GenericConfig(entriesToSave, this.objectMapper);
    }

    public void handleCaptureAgentLogs(LinkedHashMap<?, ?> innerMap) {
        LogHandlerParameters operation = new LogHandlerParameters();
        operation.setOperationId(innerMap.get("operationId").toString());
        if (innerMap.containsKey("loggerName") && innerMap.get("loggerName") != null) {
            String loggerName = innerMap.get("loggerName").toString();
            operation.setLoggerName(loggerName);
        }
        if (innerMap.containsKey("loggerLevel") && innerMap.get("loggerLevel") != null) {
            String level = innerMap.get("loggerLevel").toString();
            operation.setLoggerLevel(LoggerLevel.valueOf((String)level));
        }
        if (innerMap.containsKey("durationInMins") && innerMap.get("durationInMins") != null) {
            String durationInMins = innerMap.get("durationInMins").toString();
            operation.setDurationInMins(Long.parseLong(durationInMins));
        }
        boolean operationSuccessful = this.logCaptureHandler.handleCaptureLogOperation(operation);
    }

    String logsDir() {
        String AgentRuntimeDir = this.bootstrapConfig.getAgentRuntimeDir();
        log.debug("AgentRuntimeDir: " + AgentRuntimeDir);
        if (AgentRuntimeDir != null && !AgentRuntimeDir.isEmpty()) {
            return AgentRuntimeDir;
        }
        return (String)this.machineProperties.toMap().get("AppDynamics|Agent|Install Directory") + "/logs";
    }

    void updateMachineHierarchy(List<String> mutableMachineHierarchy) {
        try {
            log.debug("Cluster name is : " + this.bootstrapConfig.getClusterName());
            log.debug("Checking machine tags to see if Cluster Node tag is present");
            String K8S_CLUSTER_NODE_TAG_KEY = TagConstants.getPrefixIntegrationWithTagKey(MachineTagMapName.K8SNODE_INTEGRATION_TAG_MAP.getIntegrationName(), "Cluster Node");
            Set clusterNodeTagSet = this.machineTags.toMap().get((Object)K8S_CLUSTER_NODE_TAG_KEY);
            if (!clusterNodeTagSet.isEmpty()) {
                String clusterNodeTagValue = (String)clusterNodeTagSet.iterator().next();
                log.debug("Cluster Node Tag Value is : " + clusterNodeTagValue);
                log.debug("Adding " + this.bootstrapConfig.getClusterName() + "|" + clusterNodeTagValue + " to machine hierarchy");
                mutableMachineHierarchy.add(this.bootstrapConfig.getClusterName());
                mutableMachineHierarchy.add(clusterNodeTagValue);
            }
        }
        catch (Exception e) {
            log.debug("Error fetching kubernetes Cluster Tag");
        }
    }

    @Override
    public long getLastSuccessfulRegistrationTimestamp() {
        return this.lastSuccessfulRegistrationTimestamp.get();
    }

    private void updateLastSuccessfulRegistrationTimestamp() {
        this.lastSuccessfulRegistrationTimestamp.set(System.currentTimeMillis());
    }

    private class Reaper
    implements IAgentRunnable {
        private Reaper() {
        }

        public void run() {
            try {
                OperationInfo activeUploadLogOperation = RegistrationTask.this.logCaptureHandler.getActiveUploadLogOperation();
                if (activeUploadLogOperation != null) {
                    if (activeUploadLogOperation.isJustZipAndUploadLogs()) {
                        RegistrationTask.this.logCaptureHandler.finishOperation();
                    } else {
                        long current = System.currentTimeMillis();
                        if (current >= activeUploadLogOperation.getStartTime() + activeUploadLogOperation.getDurationInMillis()) {
                            RegistrationTask.this.logCaptureHandler.resetLoggers();
                            RegistrationTask.this.logCaptureHandler.finishOperation();
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.error("Error handling upload log or thread dump operations - ", e);
            }
        }
    }
}

