/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.registration;

import com.appdynamics.agent.sim.configuration.AgentConfig;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationRequest;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationSupplementalRequest;
import com.appdynamics.sim.common.biz.shared.machines.AssemblyDescriptors;
import com.appdynamics.sim.common.biz.shared.machines.DotnetRegistrationRequest;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.appdynamics.sim.common.biz.shared.machines.MachineInstanceRegistrationRequest;
import com.appdynamics.sim.common.rest.machines.GenericConfig;
import com.appdynamics.sim.common.rest.machines.SimMachineTypeDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfigFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentConfigFactory.class);
    private static final boolean HISTORICAL = true;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final ObjectMapper objectMapper;

    @Inject
    public AgentConfigFactory(BootstrapConfiguration bootstrapConfiguration, @AgentConfig ObjectMapper objectMapper) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.objectMapper = objectMapper;
    }

    public GenericConfig createAgentConfig(boolean isFirstRegistration, Map<String, String> machineProperties, SimMachineTypeDto simMachineType) {
        return this.createAgentConfig(isFirstRegistration, machineProperties, this.bootstrapConfiguration.getTierName(), this.bootstrapConfiguration.getNodeName(), this.bootstrapConfiguration.getApplicationName(), simMachineType, (Optional<Long>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public GenericConfig createAgentConfig(boolean isFirstRegistration, Map<String, String> machineProperties, String tierName, String nodeName, String appName, SimMachineTypeDto simMachineType, Optional<Long> hostSimMachineIdOptional, Optional<String> hostNameOptional) {
        return this.createAgentConfig(isFirstRegistration, machineProperties, tierName, nodeName, appName, simMachineType, hostSimMachineIdOptional, false, hostNameOptional);
    }

    public GenericConfig createAgentConfig(boolean isFirstRegistration, Map<String, String> machineProperties, String tierName, String nodeName, String appName, SimMachineTypeDto simMachineType, Optional<Long> hostSimMachineIdOptional, boolean markHistorical, Optional<String> hostNameOptional) {
        ImmutableSet.Builder featureSetBuilder = ImmutableSet.builder();
        featureSetBuilder.add((Object)"basic");
        if (this.bootstrapConfiguration.getSimUserEnabled().booleanValue()) {
            featureSetBuilder.add((Object)"sim");
        }
        if (this.bootstrapConfiguration.getDmmUserEnabled().booleanValue()) {
            featureSetBuilder.add((Object)"dmm");
        }
        Features features = new Features(featureSetBuilder.build());
        AgentRegistrationRequest agentRegistration = this.fromMachineProperties(machineProperties, tierName, nodeName, appName);
        MachineInstanceRegistrationRequest machineInstanceRegistration = new MachineInstanceRegistrationRequest(isFirstRegistration);
        DotnetRegistrationRequest dotnetRegistrationRequest = new DotnetRegistrationRequest(this.bootstrapConfiguration.getCompatibilityMode().booleanValue());
        AgentRegistrationSupplementalRequest.Builder agentRegistrationSupplementalRequestBuilder = AgentRegistrationSupplementalRequest.builder((String)simMachineType.name(), hostSimMachineIdOptional, hostNameOptional).containerType(machineProperties.get("CONTAINER_TYPE")).historical(markHistorical);
        ImmutableMap.Builder rawConfigBuilder = ImmutableMap.builder();
        rawConfigBuilder.put((Object)"_features", (Object)features).put((Object)"_agentRegistrationRequestConfig", (Object)agentRegistration).put((Object)"_machineInstanceRegistrationRequestConfig", (Object)machineInstanceRegistration).put((Object)"_dotnetRegistrationRequestConfig", (Object)dotnetRegistrationRequest).put((Object)"_descriptorConfig", (Object)AssemblyDescriptors.builder().emptyDescriptors().build()).put((Object)"_agentRegistrationSupplementalConfig", (Object)agentRegistrationSupplementalRequestBuilder.build());
        GenericConfig agentConfig = new GenericConfig((Map)rawConfigBuilder.build(), this.objectMapper);
        log.debug("Built agent config {}", (Object)agentConfig);
        return agentConfig;
    }

    @VisibleForTesting
    AgentRegistrationRequest fromMachineProperties(Map<String, String> machineProperties, String tierName, String nodeName, String appName) {
        AgentRegistrationRequest.Builder builder = AgentRegistrationRequest.builder((String)machineProperties.get("AppDynamics|Agent|Machine Info"), (String)machineProperties.get("AppDynamics|Agent|JVM Info"), (String)machineProperties.get("AppDynamics|Agent|Install Directory"), (String)machineProperties.get("AppDynamics|Agent|Agent version")).tierName(tierName).nodeName(nodeName).autoRegisterAgent(this.bootstrapConfiguration.getCreateNodeIfAbsent().booleanValue());
        boolean isSapMachineFlag = this.bootstrapConfiguration.getSapMachine();
        if (isSapMachineFlag) {
            builder.sapMachine(Boolean.valueOf(isSapMachineFlag));
        }
        if (appName != null) {
            builder.applicationNames(Collections.singleton(appName));
        }
        return builder.build();
    }
}

