/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.properties;

import com.appdynamics.agent.sim.time.DefaultTicker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MachinePropertyCacheProvider
implements Provider<Cache<String, String>> {
    @VisibleForTesting
    static final long DEFAULT_EXPIRATION_TIME_SECONDS = TimeUnit.MINUTES.toSeconds(3L);
    private final Ticker ticker;

    @Inject
    MachinePropertyCacheProvider(@DefaultTicker @NonNull Ticker ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.ticker = ticker;
    }

    private static <K, V> Cache<K, V> expiringCache(Ticker ticker) {
        return CacheBuilder.newBuilder().expireAfterAccess(MachinePropertyCacheProvider.expirationTimeSeconds(), TimeUnit.SECONDS).ticker(ticker).build();
    }

    private static long expirationTimeSeconds() {
        return Long.getLong("appdynamics.machine.agent.machinePropertyExpirationInterval", DEFAULT_EXPIRATION_TIME_SECONDS);
    }

    public Cache<String, String> get() {
        return MachinePropertyCacheProvider.expiringCache(this.ticker);
    }
}

