/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.prometheus.walkers;

import com.appdynamics.agent.sim.gpu.dcgm.DcgmExporterMetricNames;
import com.appdynamics.agent.sim.gpu.dcgm.GpuDcgmMetricData;
import com.appdynamics.agent.sim.prometheus.types.Counter;
import com.appdynamics.agent.sim.prometheus.types.CustomMetricFamily;
import com.appdynamics.agent.sim.prometheus.types.Gauge;
import com.appdynamics.agent.sim.prometheus.types.Histogram;
import com.appdynamics.agent.sim.prometheus.types.Summary;
import com.appdynamics.agent.sim.prometheus.walkers.IPrometheusMetricsWalker;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcgmExporterMetricsWalker
implements IPrometheusMetricsWalker<GpuDcgmMetricData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DcgmExporterMetricsWalker.class);

    @Override
    public void walkStart() {
    }

    @Override
    public void walkFinish(int familiesProcessed, int metricsProcessed) {
    }

    @Override
    public void walkMetricFamily(CustomMetricFamily family, int index, GpuDcgmMetricData metricData) {
    }

    @Override
    public void walkCounterMetric(CustomMetricFamily family, Counter counter, int index, GpuDcgmMetricData metricData) {
        try {
            Map<String, String> labels = counter.getLabels();
            String gpuId = "gpu" + labels.get("gpu");
            if (!metricData.getGpus().containsKey(gpuId)) {
                metricData.getGpus().put(gpuId, GpuDcgmMetricData.GpuData.builder().build());
            }
            String metricName = counter.getName();
            DcgmExporterMetricNames.valueOf(metricName).update(metricData.getGpus().get(gpuId), counter.getValue());
            metricData.getGpus().get(gpuId).setGpuLabels(labels);
            log.trace("DCGM Exporter Metric '{}' processes with value {}", (Object)metricName, (Object)counter.getValue());
        }
        catch (Exception e) {
            log.debug("Error processing GPU metric {}; Exception: {}", (Object)counter.getName(), (Object)e.toString());
        }
    }

    @Override
    public void walkGaugeMetric(CustomMetricFamily family, Gauge gauge, int index, GpuDcgmMetricData metricData) {
        try {
            Map<String, String> labels = gauge.getLabels();
            String gpuId = "gpu" + labels.get("gpu");
            if (!metricData.getGpus().containsKey(gpuId)) {
                metricData.getGpus().put(gpuId, GpuDcgmMetricData.GpuData.builder().build());
            }
            String metricName = gauge.getName();
            DcgmExporterMetricNames.valueOf(metricName).update(metricData.getGpus().get(gpuId), gauge.getValue());
            metricData.getGpus().get(gpuId).setGpuLabels(labels);
            log.trace("DCGM Exporter Metric '{}' processes with value {}", (Object)metricName, (Object)gauge.getValue());
        }
        catch (Exception e) {
            log.debug("Error processing GPU metric {}; Exception: {}", (Object)gauge.getName(), (Object)e.toString());
        }
    }

    @Override
    public void walkSummaryMetric(CustomMetricFamily family, Summary summary, int index, GpuDcgmMetricData metricData) {
    }

    @Override
    public void walkHistogramMetric(CustomMetricFamily family, Histogram histogram, int index, GpuDcgmMetricData metricData) {
    }

    @Override
    public boolean isMetricIncluded(String metricName) {
        return DcgmExporterMetricNames.isMetricIncluded(metricName);
    }
}

