/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.prometheus.types;

import com.appdynamics.agent.sim.prometheus.PrometheusUtils;
import com.appdynamics.agent.sim.prometheus.types.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Summary
extends Metric {
    private final long sampleCount;
    private final double sampleSum;
    private final List<Quantile> quantiles;

    private Summary(Builder builder) {
        super(builder);
        this.getLabels().remove("quantile");
        this.sampleCount = builder.sampleCount;
        this.sampleSum = builder.sampleSum;
        this.quantiles = builder.quantiles;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public double getSampleSum() {
        return this.sampleSum;
    }

    public List<Quantile> getQuantiles() {
        if (this.quantiles == null) {
            return Collections.emptyList();
        }
        return this.quantiles;
    }

    public static class Builder
    extends Metric.Builder<Builder> {
        private long sampleCount = 0L;
        private double sampleSum = Double.NaN;
        private List<Quantile> quantiles;

        @Override
        public Summary build() {
            return new Summary(this);
        }

        public Builder setSampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public Builder setSampleSum(double sampleSum) {
            this.sampleSum = sampleSum;
            return this;
        }

        public Builder addQuantile(double quantile, double value) {
            if (this.quantiles == null) {
                this.quantiles = new ArrayList<Quantile>();
            }
            this.quantiles.add(new Quantile(quantile, value));
            return this;
        }

        public Builder addQuantiles(List<Quantile> quantiles) {
            if (this.quantiles == null) {
                this.quantiles = new ArrayList<Quantile>();
            }
            this.quantiles.addAll(quantiles);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class Quantile {
        private final double quantile;
        private final double value;

        public Quantile(double quantile, double value) {
            this.quantile = quantile;
            this.value = value;
        }

        public double getQuantile() {
            return this.quantile;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s:%s", PrometheusUtils.convertDoubleToString(this.quantile), PrometheusUtils.convertDoubleToString(this.value));
        }
    }
}

