/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.prometheus;

import com.appdynamics.agent.sim.prometheus.PrometheusMetricDataParser;
import com.appdynamics.agent.sim.prometheus.types.Counter;
import com.appdynamics.agent.sim.prometheus.types.CustomMetricFamily;
import com.appdynamics.agent.sim.prometheus.types.Gauge;
import com.appdynamics.agent.sim.prometheus.types.Histogram;
import com.appdynamics.agent.sim.prometheus.types.Metric;
import com.appdynamics.agent.sim.prometheus.types.Summary;
import com.appdynamics.agent.sim.prometheus.walkers.IPrometheusMetricsWalker;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrometheusMetricsProcessor<T, M> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsProcessor.class);
    private final InputStream inputStream;
    private final IPrometheusMetricsWalker<M> walker;
    private final M metricData;

    public PrometheusMetricsProcessor(InputStream inputStream, IPrometheusMetricsWalker<M> theWalker, M metricData) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null");
        }
        this.inputStream = inputStream;
        if (theWalker == null) {
            throw new IllegalArgumentException("Prometheus metrics walker must not be null");
        }
        this.walker = theWalker;
        this.metricData = metricData;
    }

    public void walk() {
        this.walker.walkStart();
        int totalMetrics = 0;
        int familyIndex = 0;
        try {
            PrometheusMetricDataParser<T> parser = this.createPrometheusMetricDataParser();
            T metricFamily = parser.parse();
            while (metricFamily != null) {
                CustomMetricFamily convertedCustomMetricFamily = this.convert(metricFamily);
                if (!this.walker.isMetricIncluded(convertedCustomMetricFamily.getName())) {
                    ++familyIndex;
                    metricFamily = parser.parse();
                    continue;
                }
                this.walker.walkMetricFamily(convertedCustomMetricFamily, familyIndex++, this.metricData);
                int metricIndex = 0;
                for (Metric metric : convertedCustomMetricFamily.getMetrics()) {
                    switch (convertedCustomMetricFamily.getType()) {
                        case COUNTER: {
                            this.walker.walkCounterMetric(convertedCustomMetricFamily, (Counter)metric, metricIndex, this.metricData);
                            break;
                        }
                        case GAUGE: {
                            this.walker.walkGaugeMetric(convertedCustomMetricFamily, (Gauge)metric, metricIndex, this.metricData);
                            break;
                        }
                        case SUMMARY: {
                            this.walker.walkSummaryMetric(convertedCustomMetricFamily, (Summary)metric, metricIndex, this.metricData);
                            break;
                        }
                        case HISTOGRAM: {
                            this.walker.walkHistogramMetric(convertedCustomMetricFamily, (Histogram)metric, metricIndex, this.metricData);
                        }
                    }
                    ++metricIndex;
                }
                totalMetrics += convertedCustomMetricFamily.getMetrics().size();
                metricFamily = parser.parse();
            }
        }
        catch (Exception e) {
            log.error("Error while processing prometheus metric data: ", (Throwable)e);
        }
        this.walker.walkFinish(familyIndex, totalMetrics);
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected IPrometheusMetricsWalker<M> getWalker() {
        return this.walker;
    }

    protected abstract PrometheusMetricDataParser<T> createPrometheusMetricDataParser();

    protected abstract CustomMetricFamily convert(T var1);
}

