/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.monitor;

import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessPropertyOutputHandler
implements IMonitorOutputHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessPropertyOutputHandler.class);
    private static final String PROCESS_IDENTIFIER = "processes";
    private static final Splitter EQUALS_SPLITTER = Splitter.on((String)"=").limit(2).trimResults();
    private static final int FIELD_COUNT = 2;
    private final ObjectMapper objectMapper;
    private final SimProcessesAgentService processesService;
    private final String hostId;

    @Inject
    ProcessPropertyOutputHandler(ObjectMapper objectMapper, SimProcessesAgentService processesService, @HostId String hostId) {
        this.objectMapper = objectMapper;
        this.processesService = processesService;
        this.hostId = hostId;
    }

    @Override
    public void parseAndReportLine(@NonNull String monitorLine) {
        if (monitorLine == null) {
            throw new NullPointerException("monitorLine is marked non-null but is null");
        }
        if (this.isProcess(monitorLine)) {
            List<SimProcessObservationDto> processList = this.parse(monitorLine);
            List<SimProcessObservationDto> cleanList = this.removeMemberWithNullField(processList);
            this.report(cleanList);
        }
    }

    @VisibleForTesting
    List<SimProcessObservationDto> parse(String monitorLine) {
        List stringList = EQUALS_SPLITTER.splitToList((CharSequence)monitorLine);
        if (stringList.size() < 2) {
            log.warn("Unexpected process property format. Line read: " + monitorLine);
        } else {
            String jsonString = (String)stringList.get(1);
            try {
                return (List)this.objectMapper.readValue(jsonString, (TypeReference)new TypeReference<List<SimProcessObservationDto>>(){});
            }
            catch (IOException e) {
                log.warn("Cannot deserialize the process property. Line read: " + monitorLine, (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    boolean isProcess(String monitorLine) {
        return monitorLine.startsWith(PROCESS_IDENTIFIER);
    }

    @VisibleForTesting
    List<SimProcessObservationDto> removeMemberWithNullField(List<SimProcessObservationDto> originalList) {
        ArrayList<SimProcessObservationDto> cleanList = new ArrayList<SimProcessObservationDto>();
        for (SimProcessObservationDto processDto : originalList) {
            if (!ProcessPropertyOutputHandler.isAnyRequiredFieldNull(processDto)) {
                cleanList.add(processDto);
                continue;
            }
            log.warn("Process data contains null field. Dropping data: " + String.valueOf(processDto));
        }
        return Collections.unmodifiableList(cleanList);
    }

    @VisibleForTesting
    static boolean isAnyRequiredFieldNull(SimProcessObservationDto processDto) {
        return ProcessPropertyOutputHandler.isAnyObjectNull(processDto.getClassId(), processDto.getName(), processDto.getProcessClass(), processDto.getCommandLine(), processDto.getEffectiveUser(), processDto.getProperties(), processDto.getState());
    }

    private static boolean isAnyObjectNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    private void report(List<SimProcessObservationDto> dtoList) {
        this.processesService.updateProcessMetadata(this.hostId, dtoList);
    }
}

