/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SimplePercentileMetricAggregator
extends AMetricAggregator {
    @VisibleForTesting
    List<Long> valuesReported;
    private final IAgentAtomicLong lastAggregatedValue = new AgentAtomicLongImpl(0L);
    private PercentileType percentileType;

    public SimplePercentileMetricAggregator(PercentileType percentileType) {
        this.valuesReported = new ArrayList<Long>();
        this.percentileType = percentileType;
    }

    public MetricAggregatorType getType() {
        return MetricAggregatorType.PERCENTILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _report(long value) {
        SimplePercentileMetricAggregator simplePercentileMetricAggregator = this;
        synchronized (simplePercentileMetricAggregator) {
            this.valuesReported.add(value);
            this.setAsChanged();
        }
    }

    public long getLastAggregatedValue() {
        return this.lastAggregatedValue.get();
    }

    public void resetLastAggregateValue() {
        this.lastAggregatedValue.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawMetricValue aggregate() {
        RawMetricValue val = new RawMetricValue();
        List<Long> values = this.valuesReported;
        SimplePercentileMetricAggregator simplePercentileMetricAggregator = this;
        synchronized (simplePercentileMetricAggregator) {
            this.valuesReported = new ArrayList<Long>();
            this.setAsUnchanged();
        }
        Collections.sort(values);
        double percentileIndex = this.getPercentileIndex(this.percentileType.getValue(), values.size());
        if (percentileIndex >= 0.0) {
            long percentileValue;
            if (DoubleMath.isMathematicalInteger((double)percentileIndex)) {
                int percentileIndexInt = (int)percentileIndex;
                percentileValue = percentileIndex < (double)(values.size() - 1) ? (values.get(percentileIndexInt) + values.get(percentileIndexInt + 1)) / 2L : values.get(percentileIndexInt);
            } else {
                int percentileIndexInt = (int)Math.ceil(percentileIndex);
                percentileValue = values.get(percentileIndexInt);
            }
            this.lastAggregatedValue.set(percentileValue);
            val.setSum(percentileValue);
            val.setCurrent(percentileValue);
            val.setMax(percentileValue);
            val.setMin(percentileValue);
            val.setCount(1L);
        }
        return val;
    }

    @VisibleForTesting
    double getPercentileIndex(double percentile, long count) {
        if (count == 0L) {
            return -1.0;
        }
        if (count == 1L) {
            return 0.0;
        }
        return percentile * (double)count / 100.0 - 1.0;
    }

    public static enum PercentileType {
        PERCENTILE_95(95.0);

        private final double value;

        private PercentileType(double newValue) {
            this.value = newValue;
        }

        public double getValue() {
            return this.value;
        }
    }
}

