/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.metrics;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.time.DefaultTicker;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MetricAggregatorCacheProvider
implements Provider<Cache<String, IMetricAggregator>> {
    private final BootstrapConfiguration config;
    private final Ticker ticker;

    @Inject
    MetricAggregatorCacheProvider(BootstrapConfiguration config, @DefaultTicker @NonNull Ticker ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.config = config;
        this.ticker = ticker;
    }

    public Cache<String, IMetricAggregator> get() {
        return this.expiringCache(this.ticker, this.config.getMetricAggregatorCacheExpirationTimeSeconds());
    }

    private <K, V> Cache<K, V> expiringCache(Ticker ticker, long expiryTime) {
        return CacheBuilder.newBuilder().expireAfterAccess(expiryTime, TimeUnit.SECONDS).ticker(ticker).build();
    }
}

