/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.metrics;

import com.appdynamics.agent.sim.dmm.CategoryFilter;
import com.appdynamics.agent.sim.dmm.DynamicMonitoringModeManager;
import com.appdynamics.agent.sim.dmm.SimMachineIdSupplier;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricClusterRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricTimeRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.common.rest.dmm.DynamicMonitoringModeAgent;
import com.appdynamics.voltron.utils.annotations.Raw;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;

public class CategoryMetricsService
implements MetricsService {
    private static final long UNKNOWN_VALUE = -1L;
    private final MetricsService metricsService;
    private final CategoryFilter categoryFilter;
    private final DynamicMonitoringModeManager dynamicMonitoringModeManager;
    private final SimMachineIdSupplier simMachineIdSupplier;

    @Inject
    CategoryMetricsService(SimMachineIdSupplier simMachineIdSupplier, @Raw MetricsService metricsService, CategoryFilter categoryFilterService, DynamicMonitoringModeManager dynamicMonitoringModeManager) {
        this.metricsService = metricsService;
        this.categoryFilter = categoryFilterService;
        this.dynamicMonitoringModeManager = dynamicMonitoringModeManager;
        this.simMachineIdSupplier = simMachineIdSupplier;
    }

    public CategoryMetricsService(long simMachineId, MetricsService metricsService, CategoryFilter categoryFilterService, DynamicMonitoringModeManager dynamicMonitoringModeManager) {
        this.metricsService = metricsService;
        this.categoryFilter = categoryFilterService;
        this.dynamicMonitoringModeManager = dynamicMonitoringModeManager;
        this.simMachineIdSupplier = new SimMachineIdSupplier();
        this.simMachineIdSupplier.set(simMachineId);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType, value);
        }
        return false;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType, rawValue);
        }
        return false;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, holeHandlingType, value);
        }
        return false;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, holeHandlingType, rawValue);
        }
        return false;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, long value) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, value);
        }
        return false;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        if (this.isSimMachineIdAvailable()) {
            long simMachineId = (Long)this.simMachineIdSupplier.get().get();
            boolean reportMetric = this.isMetricValidForCurrentCategory(simMachineId, metricName);
            if (!reportMetric) {
                return true;
            }
            return this.metricsService.reportMetric(metricName, aggregatorType, value);
        }
        return false;
    }

    @VisibleForTesting
    boolean isMetricValidForCurrentCategory(long simMachineId, String metricName) {
        DynamicMonitoringModeAgent dmmMode = this.dynamicMonitoringModeManager.get(simMachineId);
        return this.categoryFilter.isMetricValidForCurrentCategory(metricName, dmmMode);
    }

    @VisibleForTesting
    protected boolean isSimMachineIdAvailable() {
        return this.simMachineIdSupplier.get().isPresent();
    }
}

