/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.metadata;

import com.appdynamics.agent.sim.time.DefaultTicker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

class MachineMetadataCacheProvider
implements Provider<Cache<String, Object>> {
    @VisibleForTesting
    static final long DEFAULT_EXPIRATION_TIME_SECONDS = TimeUnit.MINUTES.toSeconds(3L);
    private final Ticker ticker;

    @Inject
    MachineMetadataCacheProvider(@DefaultTicker @NonNull Ticker ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.ticker = ticker;
    }

    private static <K, V> Cache<K, V> expiringCache(Ticker ticker) {
        return CacheBuilder.newBuilder().expireAfterAccess(MachineMetadataCacheProvider.expirationTimeSeconds(), TimeUnit.SECONDS).ticker(ticker).build();
    }

    private static long expirationTimeSeconds() {
        return Long.getLong("appdynamics.machine.agent.machineMetadataExpirationInterval", DEFAULT_EXPIRATION_TIME_SECONDS);
    }

    public Cache<String, Object> get() {
        return MachineMetadataCacheProvider.expiringCache(this.ticker);
    }
}

