/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.logOperations;

import com.appdynamics.agent.sim.logOperations.ADRollingRandomAccessFileAppender;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicBooleanImpl;
import com.singularity.ee.util.spi.IAgentAtomicBoolean;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.appender.rolling.action.GzCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.ZipCompressAction;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ADRolloverStrategy", category="Core", printObject=true)
public class ADRolloverStrategy
implements RolloverStrategy {
    private static final String EXT_ZIP = ".zip";
    private static final String EXT_GZIP = ".gz";
    private static final String DOT_LOG = ".log";
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    protected static final Logger LOGGER = StatusLogger.getLogger();
    public static final int NUM_MUST_EXIST_FILE = 2;
    public static final String FIRST_LOG = ".0.log";
    private final IAgentAtomicBoolean firstRollover = new AgentAtomicBooleanImpl(true);
    private int maxBackupFiles;
    private int compressionLevel;
    private String compressionExtension;
    private int currentIndex;

    private ADRolloverStrategy(int maxBackupFiles, int compressionLevel, String compressionExtension) {
        this.maxBackupFiles = maxBackupFiles;
        this.compressionLevel = compressionLevel;
        this.compressionExtension = compressionExtension;
    }

    @PluginFactory
    public static ADRolloverStrategy createStrategy(@PluginAttribute(value="max") String max, @PluginAttribute(value="compressionLevel") String compressionLevelStr, @PluginAttribute(value="format") String format) {
        int compressionLevel;
        int maxBackupFiles = 7;
        if (max != null && (maxBackupFiles = Integer.parseInt(max)) < 1) {
            maxBackupFiles = 1;
            LOGGER.warn("Will only zip first log file. Will not roll any log file");
        }
        String compressionExtension = (compressionLevel = Integers.parseInt((String)compressionLevelStr, (int)-1)) == 0 ? "" : ("zip".equalsIgnoreCase(format) ? EXT_ZIP : EXT_GZIP);
        return new ADRolloverStrategy(maxBackupFiles, compressionLevel, compressionExtension);
    }

    public RolloverDescription rollover(RollingFileManager manager) {
        String renameTo;
        final String activeFileName = manager.getFileName();
        File activeFile = new File(activeFileName);
        String activeFileWithoutDirName = activeFile.getName();
        String logDirectoryString = activeFile.getParent();
        String timeStamp = ADRollingRandomAccessFileAppender.getTimeStampString();
        int prefixIndex = activeFileWithoutDirName.indexOf(46);
        if (prefixIndex == -1) {
            prefixIndex = activeFileWithoutDirName.length();
        }
        String prefix = logDirectoryString + File.separator + activeFileWithoutDirName.substring(0, prefixIndex);
        String fileNameBase = prefix + "." + timeStamp + ".";
        if (this.firstRollover.getAndSet(false)) {
            renameTo = fileNameBase + "0.log";
            this.currentIndex = 0;
        } else if (this.maxBackupFiles > 1 && this.purgeCurrentSet(this.maxBackupFiles, fileNameBase, DOT_LOG + this.compressionExtension, activeFile)) {
            renameTo = fileNameBase + ++this.currentIndex + DOT_LOG;
        } else {
            return new RolloverDescriptionImpl(activeFileName, false, (Action)new AbstractAction(){

                public boolean execute() {
                    return new File(activeFileName).delete();
                }
            }, null);
        }
        FileRenameAction renameAction = new FileRenameAction(new File(activeFileName), new File(renameTo), true);
        GzCompressAction compressAction = null;
        if (this.compressionExtension.equals(EXT_GZIP)) {
            compressAction = new GzCompressAction(new File(renameTo), new File(renameTo + this.compressionExtension), true);
        } else if (this.compressionExtension.equals(EXT_ZIP)) {
            compressAction = new ZipCompressAction(new File(renameTo), new File(renameTo + this.compressionExtension), true, this.compressionLevel);
        }
        return new RolloverDescriptionImpl(activeFileName, false, (Action)renameAction, compressAction);
    }

    protected boolean purgeCurrentSet(int max, final String fileNameBase, final String extension, final File activeFile) {
        LOGGER.debug("Running purger");
        File logsDir = activeFile.getParentFile();
        if (logsDir == null || !logsDir.exists() || !logsDir.isDirectory()) {
            LOGGER.error("Cannot get directory. Rolling failed");
            return false;
        }
        File[] files = logsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().startsWith(fileNameBase) && file.getName().endsWith(extension) && !file.equals(activeFile);
            }
        });
        if (files == null) {
            LOGGER.error("Cannot get directory. Rolling failed");
            return false;
        }
        int deleted = 0;
        if (files.length < max) {
            return true;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return ADRolloverStrategy.this.compareRollingDigits(o1, o2, fileNameBase, extension);
            }
        });
        for (int i = 0; i < files.length && files.length - deleted >= max; ++i) {
            if (files[i].getName().contains(FIRST_LOG)) continue;
            File oldestFile = files[i];
            if (!oldestFile.exists()) {
                LOGGER.warn("File does not exist will not delete the oldest file");
            }
            if (!oldestFile.delete()) {
                LOGGER.warn("Failed to delete the oldest log file {}.", (Object)oldestFile.getAbsolutePath());
                continue;
            }
            LOGGER.debug("Deleted oldest file {}", (Object)oldestFile.getName());
            ++deleted;
        }
        return files.length - deleted < max;
    }

    private int compareRollingDigits(File f1, File f2, String fileNameBase, String extension) {
        String p1 = f1.getAbsolutePath();
        String p2 = f2.getAbsolutePath();
        return StringOperations.safeParseInteger((String)p1.substring(fileNameBase.length(), p1.length() - extension.length()), (int)-1) - StringOperations.safeParseInteger((String)p2.substring(fileNameBase.length(), p2.length() - extension.length()), (int)-1);
    }

    public String toString() {
        return String.format("ADRolloverStrategy with max %d, compressionLevel %d, format %s", this.maxBackupFiles, this.compressionLevel, this.compressionExtension);
    }
}

