/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.logOperations;

import com.appdynamics.agent.sim.logOperations.ADRolloverStrategy;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ADRollingRandomAccessFileAppender {
    private static String timeStampString = new SimpleDateFormat("yyyy_MM_dd__HH_mm_ss").format(new Date());
    private static final String DOT_LOG = ".log";
    private static volatile String fallBackDirectory = null;
    private String logFileName = null;
    private String logDir = null;

    public ADRollingRandomAccessFileAppender(String logDir, String logFileName) {
        this.logDir = logDir;
        this.logFileName = logFileName;
    }

    public RollingRandomAccessFileAppender createAppender() {
        this.logFileName = ADRollingRandomAccessFileAppender.generateFileName(this.logDir, this.logFileName);
        String logFilePattern = this.logFileName.replace(DOT_LOG, "-%i.log");
        RollingRandomAccessFileAppender rollingRandomAccessFileAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withFileName(this.logFileName).withName("CustomLogRequestAppender")).withFilePattern(logFilePattern).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)"5 MB")).withStrategy((RolloverStrategy)ADRolloverStrategy.createStrategy("5", "1", "gz")).withLayout((Layout)PatternLayout.newBuilder().withPattern("[%t] %d{DATE} %5p %c - %m%n").build())).build();
        return rollingRandomAccessFileAppender;
    }

    protected static String generateFileName(String directory, String filename) {
        if (filename.endsWith(DOT_LOG)) {
            String prefixDir = directory != null ? directory : fallBackDirectory;
            return prefixDir + File.separator + filename.substring(0, filename.length() - DOT_LOG.length()) + "." + timeStampString + DOT_LOG;
        }
        return filename;
    }

    public static String getTimeStampString() {
        return timeStampString;
    }
}

