/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.lightagent;

import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.sim.common.rest.machines.ContainerType;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightSystemAgentRegistry
implements LightAgentRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightSystemAgentRegistry.class);
    private static final boolean MONITOR_APM_CONTAINERS_ONLY_DEFAULT = true;
    private final Map<String, LightSystemAgent> hostIdToLightSystemAgent = new ConcurrentHashMap<String, LightSystemAgent>();
    private Provider<AgentMonitorConfig> agentMonitorConfigProvider;

    @Inject
    public LightSystemAgentRegistry(Provider<AgentMonitorConfig> agentMonitorConfigProvider) {
        this.agentMonitorConfigProvider = agentMonitorConfigProvider;
    }

    @Override
    public void registerAgent(String hostId, LightSystemAgent agent) {
        this.hostIdToLightSystemAgent.put(hostId, agent);
    }

    @Override
    public LightSystemAgent remove(String hostId) {
        LightSystemAgent lightSystemAgent = this.hostIdToLightSystemAgent.remove(hostId);
        lightSystemAgent.stop();
        return lightSystemAgent;
    }

    @Override
    public Optional<LightSystemAgent> getAgent(String hostId) {
        return Optional.fromNullable((Object)this.hostIdToLightSystemAgent.get(hostId));
    }

    @Override
    public Map<String, LightSystemAgent> removeNonRunningContainers(Set<String> nonRunningContainerIds) {
        ImmutableMap.Builder removedAgents = new ImmutableMap.Builder();
        log.debug("Removing the following non-running containers from the LightSystemAgent Registry - {}", nonRunningContainerIds);
        for (String hostId : nonRunningContainerIds) {
            LightSystemAgent removedAgent = this.remove(hostId);
            removedAgents.put((Object)hostId, (Object)removedAgent);
        }
        return removedAgents.build();
    }

    @Override
    public Set<String> getNonRunningContainers(Set<String> runningContainerIds) {
        return Sets.difference(this.hostIdToLightSystemAgent.keySet(), runningContainerIds);
    }

    @Override
    public Set<String> getNonApmContainersToBeMarkedHistorical() {
        HashSet<String> containersToBeRemoved = new HashSet<String>();
        boolean isMonitorOnlyAPMContainers = (Boolean)((AgentMonitorConfig)this.agentMonitorConfigProvider.get()).isMonitorApmContainersOnlyEnabled().or((Object)true);
        if (!isMonitorOnlyAPMContainers) {
            return containersToBeRemoved;
        }
        for (String hostId : this.getAllRunningContainerIds()) {
            Optional<LightSystemAgent> lightSystemAgentOpt = Optional.absent();
            try {
                lightSystemAgentOpt = this.getAgent(hostId);
            }
            catch (RuntimeException e) {
                log.warn("Error getting lightSystemAgent for hostId: {} ", (Object)hostId);
            }
            boolean isNonAPMContainer = false;
            if (lightSystemAgentOpt.isPresent() && ((LightSystemAgent)lightSystemAgentOpt.get()).getContainerType().isPresent()) {
                ContainerType containerType = (ContainerType)((LightSystemAgent)lightSystemAgentOpt.get()).getContainerType().get();
                boolean bl = isNonAPMContainer = containerType == ContainerType.NON_APM;
            }
            if (!isMonitorOnlyAPMContainers || !isNonAPMContainer) continue;
            containersToBeRemoved.add(hostId);
        }
        return containersToBeRemoved;
    }

    @Override
    public Set<String> getAllRunningContainerIds() {
        return this.hostIdToLightSystemAgent.keySet();
    }

    @Override
    public Set<Long> getContainerSimMachineIds() {
        ImmutableSet.Builder simMachineIds = ImmutableSet.builder();
        for (Map.Entry<String, LightSystemAgent> entry : this.hostIdToLightSystemAgent.entrySet()) {
            LightSystemAgent lightSystemAgent = entry.getValue();
            simMachineIds.add((Object)lightSystemAgent.getSimMachineId());
        }
        return simMachineIds.build();
    }
}

