/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.lightagent;

import com.appdynamics.agent.sim.lightagent.LightAgent;
import com.appdynamics.agent.sim.lightagent.LightAgentMachinePropertiesFactory;
import com.appdynamics.agent.sim.lightagent.LightAgentMetricGenerationServiceFactory;
import com.appdynamics.agent.sim.lightagent.LightAgentMetricSenderFactory;
import com.appdynamics.agent.sim.lightagent.LightAgentMetricsServiceFactory;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgentFactory;
import com.appdynamics.agent.sim.lightagent.LightSystemAgentRegistry;
import com.appdynamics.agent.sim.lightagent.MetricGenerationServiceFactory;
import com.appdynamics.agent.sim.lightagent.MetricsServiceFactory;
import com.appdynamics.agent.sim.lightagent.PublishQueueLengthSupplierProvider;
import com.appdynamics.agent.sim.lightagent.SystemAgentMetricSenderFactory;
import com.appdynamics.agent.sim.metrics.MetricAggregatorCacheProvider;
import com.appdynamics.agent.sim.properties.MachinePropertyCacheProvider;
import com.google.common.cache.Cache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import com.singularity.ee.agent.commonservices.eventgeneration.EventGenerationService;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.resolver.PublishQueueLengthSupplier;
import com.singularity.ee.agent.systemagent.logger.Slf4JLoggerAdapter;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.logging.Slf4JLogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.lang.annotation.Annotation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightSystemAgentModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightSystemAgentModule.class);
    private static final int DEFAULT_EVENT_PUBLISHING_FREQUENCY_IN_MILLIS = 60000;

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(LightSystemAgentFactory.class));
        this.bind(MetricGenerationServiceFactory.class).to(LightAgentMetricGenerationServiceFactory.class);
        this.bind(SystemAgentMetricSenderFactory.class).to(LightAgentMetricSenderFactory.class);
        this.bind(MetricsServiceFactory.class).to(LightAgentMetricsServiceFactory.class);
        this.bind(LightAgentMachinePropertiesFactory.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"envmonitor.aggregation.frequency")).to(this.getMetricAggregationFrequency());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"appdynamics.agent.maxMetrics")).to(this.getMetricMaxAllowed());
        this.bind(PublishQueueLengthSupplier.class).toProvider(PublishQueueLengthSupplierProvider.class).in(Scopes.SINGLETON);
        this.bind(IADLogger.class).annotatedWith(LightAgent.class).toInstance((Object)new Slf4JLoggerAdapter(new Slf4JLogger(log)));
        this.bind((TypeLiteral)new TypeLiteral<Cache<String, IMetricAggregator>>(){}).annotatedWith(LightAgent.class).toProvider(MetricAggregatorCacheProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Cache<String, String>>(){}).annotatedWith(LightAgent.class).toProvider(MachinePropertyCacheProvider.class);
        this.bind(LightAgentRegistry.class).to(LightSystemAgentRegistry.class).in(Scopes.SINGLETON);
    }

    @Provides
    @LightAgent
    IEventGenerationService providesEventGenerationService(@LightAgent IADLogger logger, IControllerTimeSkewHandler skewHandler, IAgentScheduledExecutorService agentScheduledExecutorService) {
        int eventPublishingFrequency = Integer.getInteger("appdynamics.event.publish.interval", 60000);
        return new EventGenerationService(logger, eventPublishingFrequency, agentScheduledExecutorService, skewHandler);
    }

    int getMetricAggregationFrequency() {
        return SystemUtilsTranslateable.getIntProperty((String)"envmonitor.aggregation.frequency", (int)60000);
    }

    int getMetricMaxAllowed() {
        return SystemUtilsTranslateable.getIntProperty((String)"appdynamics.agent.maxMetrics", (int)1450);
    }
}

