/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.k8s;

import com.appdynamics.agent.sim.k8s.K8sClient;
import com.appdynamics.agent.sim.k8s.K8sHelper;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fabric8Client
implements K8sClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Fabric8Client.class);
    private static final String K8S_DOCKER_CONTAINER_ID_PREFIX = "docker://";
    private final Optional<KubernetesClient> client;
    private final K8sHelper helper;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    public Fabric8Client(K8sHelper helper, Provider<KubernetesClient> clientProvider, SimAgentRepetitiveLogger repetitiveLogger) {
        this.client = this.getKubernetesClient(clientProvider);
        this.helper = helper;
        this.repetitiveLogger = repetitiveLogger;
    }

    @Override
    public Map<String, String> getReplicaSetLabelsByContainerId(String targetContainerId) {
        log.debug("Getting K8s rs labels for container with id: " + targetContainerId);
        HashMap<String, String> containerLabels = new HashMap<String, String>();
        Optional<Pod> podOpt = this.getPodByContainerId(targetContainerId);
        if (!podOpt.isPresent()) {
            return containerLabels;
        }
        ObjectMeta podMeta = ((Pod)podOpt.get()).getMetadata();
        containerLabels.put("pod", podMeta.getName());
        this.addLabels(containerLabels, "pod", podMeta);
        Optional<ReplicaSet> rsOpt = this.findReplicaSetForPod((Pod)podOpt.get());
        if (rsOpt.isPresent()) {
            ReplicaSet rs = (ReplicaSet)rsOpt.get();
            containerLabels.put("rs", rs.getMetadata().getName());
            this.addLabels(containerLabels, "rs", rs.getMetadata());
        }
        return containerLabels;
    }

    @Override
    public Map<String, String> getPodLabelsByContainerId(String targetContainerId) {
        log.debug("Getting K8s labels for container with id: " + targetContainerId);
        HashMap<String, String> containerLabels = new HashMap<String, String>();
        if (!this.client.isPresent()) {
            return containerLabels;
        }
        PodList podList = (PodList)((FilterWatchListMultiDeletable)((KubernetesClient)this.client.get()).pods().inAnyNamespace()).list();
        for (Pod pod : podList.getItems()) {
            List containerStatuses = pod.getStatus().getContainerStatuses();
            if (!this.hasContainerStatus(containerStatuses, targetContainerId)) continue;
            ObjectMeta podMeta = pod.getMetadata();
            containerLabels.put("pod", podMeta.getName());
            this.addLabels(containerLabels, "pod", podMeta);
        }
        if (log.isTraceEnabled()) {
            StringBuilder logStrBuilder = new StringBuilder("Collected labels: ");
            for (Map.Entry entry : containerLabels.entrySet()) {
                logStrBuilder.append((String)entry.getKey()).append(" - ").append((String)entry.getValue());
            }
            log.trace(logStrBuilder.toString());
        }
        log.debug("Size of K8s labels collected: " + containerLabels.size());
        return containerLabels;
    }

    private Optional<Pod> getPodByContainerId(String targetContainerId) {
        Optional podOpt = Optional.absent();
        if (!this.client.isPresent()) {
            return podOpt;
        }
        PodList podList = (PodList)((FilterWatchListMultiDeletable)((KubernetesClient)this.client.get()).pods().inAnyNamespace()).list();
        for (Pod pod : podList.getItems()) {
            List containerStatuses = pod.getStatus().getContainerStatuses();
            if (!this.hasContainerStatus(containerStatuses, targetContainerId)) continue;
            podOpt = Optional.of((Object)pod);
            break;
        }
        return podOpt;
    }

    private Optional<ReplicaSet> findReplicaSetForPod(Pod pod) {
        if (!this.client.isPresent()) {
            return Optional.absent();
        }
        for (OwnerReference owner : pod.getMetadata().getOwnerReferences()) {
            log.trace("  Owner reference - kind: " + owner.getKind() + ", name: " + owner.getName());
            if (!owner.getKind().contains("ReplicaSet")) continue;
            try {
                ReplicaSetList rsList = (ReplicaSetList)((FilterWatchListMultiDeletable)((KubernetesClient)this.client.get()).extensions().replicaSets().inAnyNamespace()).list();
                for (ReplicaSet rs : rsList.getItems()) {
                    if (!rs.getMetadata().getName().equals(owner.getName())) continue;
                    return Optional.of((Object)rs);
                }
            }
            catch (Exception e) {
                this.repetitiveLogger.error(log, "ReplicaSet call to get labels failed due to exception:", e);
            }
        }
        return Optional.absent();
    }

    private void addLabels(Map<String, String> output, String prefix, ObjectMeta meta) {
        Map labels = meta.getLabels();
        for (Map.Entry e : labels.entrySet()) {
            String key = this.helper.getKey(prefix, (String)e.getKey());
            output.put(key, (String)e.getValue());
        }
    }

    private boolean hasContainerStatus(List<ContainerStatus> containerStatuses, String containerId) {
        String dockerIdWithPrefix = K8S_DOCKER_CONTAINER_ID_PREFIX + containerId;
        for (ContainerStatus containerStatus : containerStatuses) {
            if (!dockerIdWithPrefix.equals(containerStatus.getContainerID())) continue;
            return true;
        }
        return false;
    }

    private Optional<KubernetesClient> getKubernetesClient(Provider<KubernetesClient> clientProvider) {
        Optional cli = Optional.absent();
        try {
            cli = Optional.of((Object)((KubernetesClient)clientProvider.get()));
            ((KubernetesClient)cli.get()).getVersion();
        }
        catch (Exception e) {
            cli = Optional.absent();
            log.info("No Kubernetes was detected.");
            log.debug("K8s error", (Throwable)e);
        }
        return cli;
    }
}

