/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.extensions.scheduling;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagedScheduledThreadPool
extends ScheduledThreadPoolExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedScheduledThreadPool.class);
    private final long shutdownTimeoutMillis;

    @Inject
    private ManagedScheduledThreadPool(BootstrapConfiguration config) {
        super((int)config.getExtensionsSchedulerCorePoolSize(), ManagedScheduledThreadPool.buildThreadFactory());
        this.shutdownTimeoutMillis = config.getExtensionsSchedulerShutdownTimeoutMillis();
    }

    @PreDestroy
    private void stop() {
        log.info("Shutting down extensions thread pool");
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this, (long)this.shutdownTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory buildThreadFactory() {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("extension-scheduler-pool-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.warn("Thread had an uncaught exception", e);
            }
        }).build();
    }
}

