/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.events;

import com.appdynamics.agent.sim.legacy.MachineId;
import com.appdynamics.agent.sim.time.AgentTimeSupplier;
import com.appdynamics.sim.agent.extensions.api.events.EventSeverity;
import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.events.EventMessage;
import com.singularity.ee.events.MachineEventData;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventsService
implements EventsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventsService.class);
    private final Provider<IEventGenerationService> eventGenerationService;
    private final Provider<Optional<Long>> machineId;
    private final AgentTimeSupplier timeSupplier;

    @Inject
    @VisibleForTesting
    DefaultEventsService(Provider<IEventGenerationService> eventGenerationService, @MachineId Provider<Optional<Long>> machineId, AgentTimeSupplier timeSupplier) {
        this.eventGenerationService = eventGenerationService;
        this.machineId = machineId;
        this.timeSupplier = timeSupplier;
    }

    public void reportCustomEvent(EventSeverity severity, String type, String summaryMessage, Map<String, Object> properties, Map<String, String> details) {
        if (!((Optional)this.machineId.get()).isPresent()) {
            log.warn("Attempted to send an event of type '{}' with message '{}' before the agent was registered. Ignoring.", (Object)type, (Object)summaryMessage);
        } else {
            MachineEventData eventData = new MachineEventData(this.timeSupplier.getAgentTime(), DefaultEventsService.severityFromEventSeverity(severity), EventType.CUSTOM, (Map)ImmutableMap.copyOf(details), summaryMessage, ((Long)((Optional)this.machineId.get()).get()).longValue());
            eventData.setSubType(type);
            eventData.setEventProperties((Map)ImmutableMap.copyOf(properties));
            ((IEventGenerationService)this.eventGenerationService.get()).addMachineEvent(eventData);
        }
    }

    public void reportEvent(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, EventMessage message, Optional<Long> machineIdOpt, Optional<String> subtypeOpt, Optional<EntityDefinition> triggeredEntityOpt) {
        Optional<Long> machineIdToReport = this.getCurrentMachineId(machineIdOpt);
        if (!machineIdToReport.isPresent()) {
            log.warn("Attempted to send an event of type '{}' with message '{}' before the agent was registered. Ignoring.", (Object)type, (Object)message);
            return;
        }
        MachineEventData eventData = new MachineEventData(timestamp, notificationSeverity, type, eventDetails, message, ((Long)machineIdToReport.get()).longValue());
        if (subtypeOpt.isPresent()) {
            eventData.setSubType((String)subtypeOpt.get());
        }
        if (triggeredEntityOpt.isPresent()) {
            eventData.setTriggeredEntity((EntityDefinition)triggeredEntityOpt.get());
        }
        ((IEventGenerationService)this.eventGenerationService.get()).addMachineEvent(eventData);
    }

    @VisibleForTesting
    static NotificationSeverity severityFromEventSeverity(EventSeverity severity) {
        return NotificationSeverity.valueOf((String)severity.name());
    }

    private Optional<Long> getCurrentMachineId(Optional<Long> machineIdOpt) {
        if (machineIdOpt.isPresent()) {
            return machineIdOpt;
        }
        if (((Optional)this.machineId.get()).isPresent()) {
            return (Optional)this.machineId.get();
        }
        return Optional.absent();
    }
}

