/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.encryption;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.annotations.Raw;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapperFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EncryptionWrapperProvider
implements Provider<Optional<KeyStoreBasedEncryptionWrapper>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionWrapperProvider.class);
    private final BootstrapConfiguration bootstrapConfiguration;
    private final KeyStoreBasedEncryptionWrapperFactory encryptionWrapperFactory;

    @Inject
    @VisibleForTesting
    EncryptionWrapperProvider(@Raw BootstrapConfiguration bootstrapConfiguration, KeyStoreBasedEncryptionWrapperFactory encryptionWrapperFactory) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.encryptionWrapperFactory = encryptionWrapperFactory;
    }

    public Optional<KeyStoreBasedEncryptionWrapper> get() {
        if (this.bootstrapConfiguration.getUseEncryptedCredentials().booleanValue()) {
            KeyStoreBasedEncryptionWrapper encryptionWrapper;
            try {
                encryptionWrapper = StringUtils.isNotBlank((CharSequence)this.bootstrapConfiguration.getCredentialStoreFormat()) ? this.encryptionWrapperFactory.createWithObfuscatedPassword(this.bootstrapConfiguration.getCredentialStoreFilename(), this.bootstrapConfiguration.getObfuscatedCredentialStorePassword(), this.bootstrapConfiguration.getCredentialStoreFormat()) : this.encryptionWrapperFactory.createWithObfuscatedPassword(this.bootstrapConfiguration.getCredentialStoreFilename(), this.bootstrapConfiguration.getObfuscatedCredentialStorePassword());
            }
            catch (IOException | GeneralSecurityException e) {
                log.error("Failed to read secure credential store", (Throwable)e);
                throw new ProvisionException("BootstrapConfiguration failed to load secure properties", (Throwable)e);
            }
            return Optional.of((Object)encryptionWrapper);
        }
        return Optional.absent();
    }
}

