/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker.model;

import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.agent.sim.docker.model.ContainerProcessDto;
import com.appdynamics.agent.sim.docker.model.IContainerProcessDtoFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import lombok.NonNull;

public class ContainerProcessDtoFactory
implements IContainerProcessDtoFactory {
    @VisibleForTesting
    private static Map<String, Integer> headerMap;
    private static final String UNKNOWN = "unknown";

    @Override
    public List<ContainerProcess> convertToContainerProcesses(@NotNull ContainerProcessDto containerProcessDto) {
        Map<String, Integer> propertyNameToIndexMap = ContainerProcessDtoFactory.buildOrReturnHeaderMap(containerProcessDto.getHeaderList());
        Integer commIndex = propertyNameToIndexMap.get("COMMAND");
        Integer eUserIndex = propertyNameToIndexMap.get("EUSER");
        Integer eGroupIndex = propertyNameToIndexMap.get("EGROUP");
        Integer rUserIndex = propertyNameToIndexMap.get("RUSER");
        Integer rGroupIndex = propertyNameToIndexMap.get("RGROUP");
        Integer pidIndex = propertyNameToIndexMap.get("PID");
        Integer pMemIndex = propertyNameToIndexMap.get("%MEM");
        Integer pCpuIndex = propertyNameToIndexMap.get("%CPU");
        Integer timeIndex = propertyNameToIndexMap.get("TIME");
        Integer elapsedTimeIndex = propertyNameToIndexMap.get("ELAPSED");
        Integer niceIndex = propertyNameToIndexMap.get("NI");
        Integer majFlIndex = propertyNameToIndexMap.get("MAJFL");
        Integer minFlIndex = propertyNameToIndexMap.get("MINFL");
        Integer nlwpIndex = propertyNameToIndexMap.get("NLWP");
        Integer pgidIndex = propertyNameToIndexMap.get("PGID");
        Integer ppidIndex = propertyNameToIndexMap.get("PPID");
        Integer rssIndex = propertyNameToIndexMap.get("RSS");
        Integer statIndex = propertyNameToIndexMap.get("STAT");
        Integer vszIndex = propertyNameToIndexMap.get("VSZ");
        Integer nameIndex = propertyNameToIndexMap.get("NAME");
        ImmutableList.Builder containerProcesses = ImmutableList.builder();
        for (List<String> process : containerProcessDto.getProcessList()) {
            String comm = commIndex != null ? process.get(commIndex) : UNKNOWN;
            String eUser = eUserIndex != null ? process.get(eUserIndex) : "";
            String eGroup = eGroupIndex != null ? process.get(eGroupIndex) : "";
            String rUser = rUserIndex != null ? process.get(rUserIndex) : "";
            String rGroup = rGroupIndex != null ? process.get(rGroupIndex) : "";
            Long pid = pidIndex != null ? Long.valueOf(process.get(pidIndex)) : -1L;
            String pMem = pMemIndex != null ? process.get(pMemIndex) : "0.0";
            String pCpu = pCpuIndex != null ? process.get(pCpuIndex) : "0.0";
            String cpuTime = timeIndex != null ? process.get(timeIndex) : "00:00:00";
            String elapsedTime = elapsedTimeIndex != null ? process.get(elapsedTimeIndex) : "00:00:00";
            String nice = niceIndex != null ? process.get(niceIndex) : "0";
            Long majFl = majFlIndex != null ? Long.valueOf(process.get(majFlIndex)) : 0L;
            Long minFl = minFlIndex != null ? Long.valueOf(process.get(minFlIndex)) : 0L;
            Long threadCount = nlwpIndex != null ? Long.valueOf(process.get(nlwpIndex)) : 0L;
            Long pgid = pgidIndex != null ? Long.valueOf(process.get(pgidIndex)) : -1L;
            Long ppid = ppidIndex != null ? Long.valueOf(process.get(ppidIndex)) : -1L;
            Long memoryUsedKb = rssIndex != null ? Long.valueOf(process.get(rssIndex)) : 0L;
            String stat = statIndex != null ? process.get(statIndex) : "";
            Long virtualMemSizeKb = vszIndex != null ? Long.valueOf(process.get(vszIndex)) : 0L;
            String name = nameIndex != null ? process.get(nameIndex) : UNKNOWN;
            ContainerProcess newProcess = new ContainerProcess(comm, eUser, eGroup, rUser, rGroup, pid, pMem, pCpu, cpuTime, elapsedTime, nice, majFl, minFl, threadCount, pgid, ppid, memoryUsedKb, stat, virtualMemSizeKb, name);
            containerProcesses.add((Object)newProcess);
        }
        return containerProcesses.build();
    }

    @VisibleForTesting
    static synchronized Map<String, Integer> buildOrReturnHeaderMap(@NonNull List<String> header) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (headerMap != null) {
            return headerMap;
        }
        headerMap = ContainerProcessDtoFactory.buildMapFromHeader(header);
        return headerMap;
    }

    private static Map<String, Integer> buildMapFromHeader(List<String> header) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet<String> headers = new HashSet<String>();
        for (int i = 0; i < header.size(); ++i) {
            if (header.get(i) != null && header.get(i).equals("COMMAND") && !headers.contains(header.get(i))) {
                mapBuilder.put((Object)"NAME", (Object)i);
            } else if (header.get(i) != null) {
                mapBuilder.put((Object)header.get(i), (Object)i);
            }
            headers.add(header.get(i));
        }
        return mapBuilder.build();
    }

    @Generated
    public ContainerProcessDtoFactory() {
    }

    @Generated
    static void setHeaderMap(Map<String, Integer> headerMap) {
        ContainerProcessDtoFactory.headerMap = headerMap;
    }
}

