/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.UnixSocketHttpUtils;
import com.appdynamics.agent.sim.docker.model.ContainerDto;
import com.appdynamics.agent.sim.docker.model.ContainerProcessDto;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesMinimalDto;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.agent.sim.docker.model.ImagePropertiesDto;
import com.appdynamics.agent.sim.docker.model.ServerDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.PathParam;
import javax.xml.ws.WebServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnixSocketDockerService
implements DockerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnixSocketDockerService.class);
    private final ObjectMapper objectMapper;
    private final UnixSocketHttpUtils unixSocketHttpUtils;

    @Override
    public ServerDto getServerInfo() {
        return this.getResponse("/info", (Optional<Map<String, String>>)Optional.absent(), ServerDto.class);
    }

    @Override
    public List<ContainerDto> getContainers() {
        Object[] containerDtos = this.getResponse("/containers/json", (Optional<Map<String, String>>)Optional.absent(), ContainerDto[].class);
        return ImmutableList.copyOf((Object[])containerDtos);
    }

    @Override
    public ContainerProcessDto getProcessesForContainer(String containerId) {
        ImmutableMap paramsMap = ImmutableMap.of((Object)"{containerId}", (Object)containerId);
        return this.getResponse("/containers/{containerId}/top?ps_args=-eww%20-o%20comm%20-o%20euser:30%20-o%20egroup:30%20-o%20ruser:30%20-o%20rgroup:30%20-o%20pid%20-o%20%25mem%20-o%20%25cpu%20-o%20cputime%20-o%20etime%20-o%20nice%20-o%20maj_flt%20-o%20min_flt%20-o%20nlwp%20-o%20pgid%20-o%20ppid%20-o%20rss%20-o%20stat%20-o%20vsize%20-o%20args", (Optional<Map<String, String>>)Optional.of((Object)paramsMap), ContainerProcessDto.class);
    }

    @Override
    public DockerApiContainerMetricsRawData getContainerMetricsRawData(String containerId) {
        ImmutableMap paramsMap = ImmutableMap.of((Object)"{containerId}", (Object)containerId);
        return this.getResponse("/containers/{containerId}/stats?stream=false", (Optional<Map<String, String>>)Optional.of((Object)paramsMap), DockerApiContainerMetricsRawData.class);
    }

    @Override
    public ContainerPropertiesDto getContainerProperties(String containerId) {
        ImmutableMap paramsMap = ImmutableMap.of((Object)"{containerId}", (Object)containerId);
        return this.getResponse("/containers/{containerId}/json", (Optional<Map<String, String>>)Optional.of((Object)paramsMap), ContainerPropertiesDto.class);
    }

    @Override
    public ContainerPropertiesMinimalDto getContainerPropertiesMinimal(String containerId) {
        ImmutableMap paramsMap = ImmutableMap.of((Object)"{containerId}", (Object)containerId);
        return this.getResponse("/containers/{containerId}/json", (Optional<Map<String, String>>)Optional.of((Object)paramsMap), ContainerPropertiesMinimalDto.class);
    }

    @Override
    public ImagePropertiesDto getImageProperties(@PathParam(value="imageName") String imageName) {
        ImmutableMap paramsMap = ImmutableMap.of((Object)"{imageName}", (Object)imageName);
        return this.getResponse("/images/{imageName}/json", (Optional<Map<String, String>>)Optional.of((Object)paramsMap), ImagePropertiesDto.class);
    }

    @VisibleForTesting
    String getPathWithParamValuesFilled(String basePathUrl, Map<String, String> paramsMap) {
        String pathUrl = basePathUrl;
        for (Map.Entry<String, String> paramsEntry : paramsMap.entrySet()) {
            pathUrl = pathUrl.replace(paramsEntry.getKey(), paramsEntry.getValue());
        }
        return pathUrl;
    }

    private <T> T getResponse(String basePathUrl, Optional<Map<String, String>> paramsMap, Class<T> type) {
        String pathUrl = paramsMap.isPresent() ? this.getPathWithParamValuesFilled(basePathUrl, (Map)paramsMap.get()) : basePathUrl;
        Optional<String> response = this.unixSocketHttpUtils.getResponseForRequestedUrl("GET", pathUrl);
        if (response.isPresent()) {
            return this.createDtoFromResponse((String)response.get(), type);
        }
        throw new WebServiceException("Could not retrieve response from Docker API " + basePathUrl + ".'");
    }

    private <T> T createDtoFromResponse(String response, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(response.getBytes(), type);
        }
        catch (IOException e) {
            String message = "Failed to translate the response from the Docker API call to " + type.getName() + ".  The reported error is: " + String.valueOf(e);
            throw new WebServiceException(message);
        }
    }

    @Generated
    UnixSocketDockerService(ObjectMapper objectMapper, UnixSocketHttpUtils unixSocketHttpUtils) {
        this.objectMapper = objectMapper;
        this.unixSocketHttpUtils = unixSocketHttpUtils;
    }

    @Generated
    public static UnixSocketDockerServiceBuilder builder() {
        return new UnixSocketDockerServiceBuilder();
    }

    @Generated
    public static class UnixSocketDockerServiceBuilder {
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private UnixSocketHttpUtils unixSocketHttpUtils;

        @Generated
        UnixSocketDockerServiceBuilder() {
        }

        @Generated
        public UnixSocketDockerServiceBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public UnixSocketDockerServiceBuilder unixSocketHttpUtils(UnixSocketHttpUtils unixSocketHttpUtils) {
            this.unixSocketHttpUtils = unixSocketHttpUtils;
            return this;
        }

        @Generated
        public UnixSocketDockerService build() {
            return new UnixSocketDockerService(this.objectMapper, this.unixSocketHttpUtils);
        }

        @Generated
        public String toString() {
            return "UnixSocketDockerService.UnixSocketDockerServiceBuilder(objectMapper=" + String.valueOf(this.objectMapper) + ", unixSocketHttpUtils=" + String.valueOf(this.unixSocketHttpUtils) + ")";
        }
    }
}

