/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.DockerEngine;
import com.appdynamics.agent.sim.docker.DockerFeign;
import com.appdynamics.agent.sim.docker.DockerService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.jaxrs.JAXRSContract;

class TcpDockerServiceSupplier
implements Supplier<DockerService> {
    private final ObjectMapper objectMapper;
    private final Supplier<String> dockerUrlSupplier;
    private final ErrorDecoder errorDecoder;

    @Inject
    TcpDockerServiceSupplier(ObjectMapper objectMapper, @DockerEngine Supplier<String> dockerUrlSupplier, @DockerFeign ErrorDecoder errorDecoder) {
        this.objectMapper = objectMapper;
        this.dockerUrlSupplier = dockerUrlSupplier;
        this.errorDecoder = errorDecoder;
    }

    public DockerService get() {
        DockerService dockerService = (DockerService)Feign.builder().contract((Contract)new JAXRSContract()).decoder((Decoder)new JacksonDecoder(this.objectMapper)).encoder((Encoder)new JacksonEncoder(this.objectMapper)).errorDecoder(this.errorDecoder).target(DockerService.class, (String)this.dockerUrlSupplier.get());
        return dockerService;
    }
}

