/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.DockerEngine;
import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.TcpDockerServiceSupplier;
import com.appdynamics.agent.sim.docker.UnixSocketDockerServiceSupplier;
import com.google.common.base.Supplier;
import com.google.inject.Inject;

class DockerServiceSupplier
implements Supplier<DockerService> {
    private final Supplier<String> dockerUrlSupplier;
    private final UnixSocketDockerServiceSupplier unixSocketDockerServiceSupplier;
    private final TcpDockerServiceSupplier tcpDockerServiceSupplier;

    @Inject
    DockerServiceSupplier(@DockerEngine Supplier<String> dockerUrlSupplier, UnixSocketDockerServiceSupplier unixSocketDockerServiceSupplier, TcpDockerServiceSupplier tcpDockerServiceSupplier) {
        this.dockerUrlSupplier = dockerUrlSupplier;
        this.unixSocketDockerServiceSupplier = unixSocketDockerServiceSupplier;
        this.tcpDockerServiceSupplier = tcpDockerServiceSupplier;
    }

    public DockerService get() {
        String configuredUrl = (String)this.dockerUrlSupplier.get();
        if (this.isUrlForUnixSocket(configuredUrl)) {
            return this.unixSocketDockerServiceSupplier.get();
        }
        return this.tcpDockerServiceSupplier.get();
    }

    private boolean isUrlForUnixSocket(String url) {
        return url.toLowerCase().startsWith("unix://".toLowerCase());
    }
}

