/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.model.ContainerDto;
import com.appdynamics.agent.sim.docker.model.ContainerProcessDto;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesMinimalDto;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.agent.sim.docker.model.ImagePropertiesDto;
import com.appdynamics.agent.sim.docker.model.ServerDto;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

public interface DockerService {
    @Path(value="/info")
    @GET
    @Produces(value={"application/json"})
    public ServerDto getServerInfo();

    @Path(value="/containers/json")
    @GET
    @Produces(value={"application/json"})
    public List<ContainerDto> getContainers();

    @Path(value="/containers/{containerId}/top?ps_args=-eww%20-o%20comm%20-o%20euser:30%20-o%20egroup:30%20-o%20ruser:30%20-o%20rgroup:30%20-o%20pid%20-o%20%25mem%20-o%20%25cpu%20-o%20cputime%20-o%20etime%20-o%20nice%20-o%20maj_flt%20-o%20min_flt%20-o%20nlwp%20-o%20pgid%20-o%20ppid%20-o%20rss%20-o%20stat%20-o%20vsize%20-o%20args")
    @GET
    @Produces(value={"application/json"})
    public ContainerProcessDto getProcessesForContainer(@PathParam(value="containerId") String var1);

    @Path(value="/containers/{containerId}/stats?stream=false")
    @GET
    @Produces(value={"application/json"})
    public DockerApiContainerMetricsRawData getContainerMetricsRawData(@PathParam(value="containerId") String var1);

    @Path(value="/containers/{containerId}/json")
    @GET
    @Produces(value={"application/json"})
    public ContainerPropertiesDto getContainerProperties(@PathParam(value="containerId") String var1);

    @Path(value="/containers/{containerId}/json")
    @GET
    @Produces(value={"application/json"})
    public ContainerPropertiesMinimalDto getContainerPropertiesMinimal(@PathParam(value="containerId") String var1);

    @Path(value="/images/{imageName}/json")
    @GET
    @Produces(value={"application/json"})
    public ImagePropertiesDto getImageProperties(@PathParam(value="imageName") String var1);
}

