/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.voltron.rest.client.NonRestException;
import com.appdynamics.voltron.rest.utils.RestException;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerErrorDecoder
implements ErrorDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerErrorDecoder.class);
    private static final MediaType REST_EXCEPTION_CONTENT_TYPE = MediaType.valueOf((String)"application/json");

    public Exception decode(String methodKey, Response response) {
        String contentType;
        Throwable exception = null;
        Collection contentTypes = (Collection)response.headers().get("Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty() && MediaType.valueOf((String)(contentType = (String)contentTypes.iterator().next())).isCompatible(REST_EXCEPTION_CONTENT_TYPE) && response.body() != null) {
            try (InputStream input = response.body().asInputStream();){
                String errorText = CharStreams.toString((Readable)new InputStreamReader(input, Charsets.UTF_8));
                exception = new RestException(response.status(), response.reason(), errorText, false);
            }
            catch (IOException e) {
                log.warn("Could not read exception payload", (Throwable)e);
            }
        }
        if (exception == null) {
            exception = new NonRestException(methodKey, response);
        }
        return exception;
    }
}

