/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.DockerUtils;
import com.appdynamics.agent.sim.docker.model.ServerDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEngineAccessibilitySupplier
implements Supplier<Boolean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerEngineAccessibilitySupplier.class);
    private Boolean dockerEngineAccessible;
    private final Supplier<DockerService> dockerServiceSupplier;

    @Inject
    public DockerEngineAccessibilitySupplier(Supplier<DockerService> dockerServiceSupplier) {
        this.dockerServiceSupplier = dockerServiceSupplier;
    }

    public Boolean get() {
        block6: {
            if (this.dockerEngineAccessible == null) {
                if (this.isDockerMonitoringSupportedOnCurrentOS()) {
                    try {
                        DockerService dockerService = (DockerService)this.dockerServiceSupplier.get();
                        ServerDto serverDto = dockerService.getServerInfo();
                        if (serverDto != null) {
                            log.info("Docker Engine is available. Version: {}", (Object)serverDto.getDockerServerVersion());
                            this.dockerEngineAccessible = Boolean.TRUE;
                            break block6;
                        }
                        log.info("Docker Engine is unavailable");
                        this.dockerEngineAccessible = Boolean.FALSE;
                    }
                    catch (Exception e) {
                        log.debug("Exception while checking Docker info API Either the Machine Agent is running with Docker disabled or the Docker Engine is not available", (Throwable)e);
                        this.dockerEngineAccessible = Boolean.FALSE;
                    }
                } else {
                    log.info("Docker monitoring is not supported on current OS: {}. Running Machine Agent with Docker disabled", (Object)SystemUtils.OS_NAME);
                    this.dockerEngineAccessible = Boolean.FALSE;
                }
            }
        }
        return this.dockerEngineAccessible;
    }

    @VisibleForTesting
    boolean isDockerMonitoringSupportedOnCurrentOS() {
        return DockerUtils.isDockerMonitoringSupportedOnCurrentOS();
    }
}

