/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.dmm;

import com.appdynamics.agent.sim.dmm.Dmm;
import com.appdynamics.sim.common.rest.dmm.DynamicMonitoringModeAgent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMonitoringModeManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicMonitoringModeManager.class);
    private static final DynamicMonitoringModeAgent DEFAULT_MODE = DynamicMonitoringModeAgent.KPI;
    private final ReadWriteLock lock;
    private final Map<Long, DynamicMonitoringModeAgent> simMachineIdToMonitoringMode;

    @Inject
    DynamicMonitoringModeManager(@Dmm ReadWriteLock lock) {
        this.lock = lock;
        this.simMachineIdToMonitoringMode = new ConcurrentHashMap<Long, DynamicMonitoringModeAgent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public DynamicMonitoringModeAgent get(long simMachineId) {
        try {
            this.lock.readLock().lock();
            DynamicMonitoringModeAgent mode = this.simMachineIdToMonitoringMode.get(simMachineId);
            if (mode != null) {
                DynamicMonitoringModeAgent dynamicMonitoringModeAgent = mode;
                return dynamicMonitoringModeAgent;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return DEFAULT_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long simMachineId, DynamicMonitoringModeAgent dynamicMonitoringMode) {
        try {
            this.lock.writeLock().lock();
            this.simMachineIdToMonitoringMode.put(simMachineId, dynamicMonitoringMode);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Set<Long> getAllMachineIds() {
        try {
            this.lock.readLock().lock();
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.simMachineIdToMonitoringMode.keySet());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAll(Set<Long> machineIds) {
        log.debug("Removing machines IDs : {} from machine ID to dmm mode map.", machineIds);
        try {
            this.lock.writeLock().lock();
            for (long machineId : machineIds) {
                this.simMachineIdToMonitoringMode.remove(machineId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

