/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.dmm;

import com.appdynamics.agent.sim.dmm.CategoryTree;
import com.appdynamics.agent.sim.dmm.InitialDataSet;
import com.appdynamics.agent.sim.dmm.MetricCategoryDataSet;
import com.appdynamics.agent.sim.dmm.OverridingDataSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryTreeImpl
implements CategoryTree {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CategoryTreeImpl.class);
    private static final String DEFAULT_INSTANCE_KEY = "*";
    private static final String INSTANCE_TEMPLATE_REGEX = "^\\{[\\w\\s]*\\}$";
    private static final Pattern INSTANCE_TEMPLATE_PATTERN = Pattern.compile("^\\{[\\w\\s]*\\}$");
    @VisibleForTesting
    static final String ROOT_METRIC_NAME = "ROOT";
    private volatile Vertex currentTreeRoot = new Vertex("ROOT");

    @Inject
    public CategoryTreeImpl(@InitialDataSet MetricCategoryDataSet metricCategoryDataSet, @OverridingDataSet MetricCategoryDataSet overriderDataSet) {
        this.buildTree(metricCategoryDataSet, overriderDataSet);
    }

    @Override
    public Optional<List<Integer>> findCategories(@NonNull String metricName) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        Deque<String> metricNameTokenStack = this.createMetricNameTokenStack(metricName);
        return this.currentTreeRoot.traverseAndFindCategories(metricNameTokenStack);
    }

    @Override
    public void buildTree(@NonNull MetricCategoryDataSet originalCategoryDataSet, MetricCategoryDataSet ... overrideCategoryDataSets) {
        if (originalCategoryDataSet == null) {
            throw new NullPointerException("originalCategoryDataSet is marked non-null but is null");
        }
        Vertex temporaryTreeRoot = new Vertex(ROOT_METRIC_NAME);
        Map<String, List<Integer>> dataSet = originalCategoryDataSet.getData();
        this.addMetricsToTree(temporaryTreeRoot, dataSet);
        if (overrideCategoryDataSets != null) {
            for (MetricCategoryDataSet metricCategoryDataSet : overrideCategoryDataSets) {
                Map<String, List<Integer>> overridingDataSet = metricCategoryDataSet.getData();
                this.addMetricsToTree(temporaryTreeRoot, overridingDataSet);
            }
        }
        this.currentTreeRoot = temporaryTreeRoot;
    }

    @VisibleForTesting
    void addToTree(Optional<Vertex> currentNodeOptional, Deque<String> metricNameTokenStack, List<Integer> categories) {
        if (metricNameTokenStack.isEmpty()) {
            return;
        }
        if (!currentNodeOptional.isPresent()) {
            throw new IllegalArgumentException("Base tree node not present or of wrong type.");
        }
        Vertex currentVertex = (Vertex)currentNodeOptional.get();
        String metricNameToken = metricNameTokenStack.pop();
        Optional<Node> childNode = currentVertex.findChild(metricNameToken);
        if (metricNameTokenStack.isEmpty()) {
            if (INSTANCE_TEMPLATE_PATTERN.matcher(metricNameToken).matches()) {
                metricNameToken = DEFAULT_INSTANCE_KEY;
            }
            currentVertex.getChildren().put(metricNameToken, (Optional<Node>)Optional.of((Object)new Leaf(categories)));
            return;
        }
        if (!childNode.isPresent()) {
            if (INSTANCE_TEMPLATE_PATTERN.matcher(metricNameToken).matches()) {
                childNode = currentVertex.findChild(DEFAULT_INSTANCE_KEY);
                if (!childNode.isPresent()) {
                    childNode = Optional.of((Object)new Vertex(DEFAULT_INSTANCE_KEY));
                    currentVertex.addChild(DEFAULT_INSTANCE_KEY, childNode);
                }
            } else {
                childNode = Optional.of((Object)new Vertex(metricNameToken));
                currentVertex.addChild(metricNameToken, childNode);
            }
        }
        if (!(childNode.get() instanceof Vertex)) {
            throw new IllegalArgumentException("Wrong tree node type found when building metric parse tree");
        }
        Optional vertexChild = Optional.of((Object)((Vertex)childNode.get()));
        this.addToTree((Optional<Vertex>)vertexChild, metricNameTokenStack, categories);
    }

    @VisibleForTesting
    Deque<String> createMetricNameTokenStack(@NonNull String metricName) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String[] tokens = metricName.split("\\|");
        for (int i = tokens.length - 1; i >= 0; --i) {
            this.checkForMalformedToken(metricName, tokens[i]);
            stack.push(tokens[i]);
        }
        return stack;
    }

    private void checkForMalformedToken(String metricName, String metricToken) {
        if (metricToken.length() == 0) {
            throw new IllegalArgumentException("Found an empty token string in a metric name: " + metricName);
        }
    }

    private void addMetricsToTree(Vertex currentNodeOptional, Map<String, List<Integer>> dataSet) {
        for (Map.Entry<String, List<Integer>> entry : dataSet.entrySet()) {
            List<Integer> categories = entry.getValue();
            if (categories == null) continue;
            String metricName = entry.getKey();
            Deque<String> metricNameTokenStack = this.createMetricNameTokenStack(metricName);
            this.addToTree((Optional<Vertex>)Optional.of((Object)currentNodeOptional), metricNameTokenStack, categories);
        }
    }

    @Generated
    Vertex getCurrentTreeRoot() {
        return this.currentTreeRoot;
    }

    static class Vertex
    implements Node {
        private final String token;
        private final HashMap<String, Optional<Node>> children;

        public Vertex(@NonNull String token) {
            if (token == null) {
                throw new NullPointerException("token is marked non-null but is null");
            }
            this.token = token;
            this.children = new HashMap();
        }

        @Override
        public Optional<List<Integer>> traverseAndFindCategories(Deque<String> target) {
            if (target.isEmpty()) {
                return Optional.absent();
            }
            return this.traverseChildren(target);
        }

        public Optional<Node> findChild(String childName) {
            Optional childNode = this.getChildren().get(childName);
            if (childNode == null) {
                childNode = Optional.absent();
            }
            return childNode;
        }

        public void addChild(String metricNameToken, Optional<Node> node) {
            HashMap<String, Optional<Node>> childMap = this.getChildren();
            childMap.put(metricNameToken, node);
        }

        private Optional<List<Integer>> traverseChildren(Deque<String> target) {
            String partName = target.pop();
            Optional<Node> child = this.findChild(partName);
            if (!child.isPresent()) {
                child = this.findChild(CategoryTreeImpl.DEFAULT_INSTANCE_KEY);
                if (!child.isPresent()) {
                    return Optional.absent();
                }
                if (child.get() instanceof Leaf) {
                    return Optional.of(((Leaf)child.get()).getCategories());
                }
            }
            return ((Node)child.get()).traverseAndFindCategories(target);
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public HashMap<String, Optional<Node>> getChildren() {
            return this.children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            HashMap<String, Optional<Node>> this$children = this.getChildren();
            HashMap<String, Optional<Node>> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Vertex;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            HashMap<String, Optional<Node>> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CategoryTreeImpl.Vertex(token=" + this.getToken() + ", children=" + String.valueOf(this.getChildren()) + ")";
        }
    }

    static class Leaf
    implements Node {
        private List<Integer> categories;

        @Override
        public Optional<List<Integer>> traverseAndFindCategories(Deque<String> target) {
            if (!target.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(this.categories);
        }

        @Generated
        public Leaf(List<Integer> categories) {
            this.categories = categories;
        }

        @Generated
        List<Integer> getCategories() {
            return this.categories;
        }
    }

    static interface Node {
        public Optional<List<Integer>> traverseAndFindCategories(Deque<String> var1);
    }
}

