/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.containerd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdUtils.class);

    public static String getHostname1() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getHostname2() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("hostname", "-f");
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine();
        int exitCode = process.waitFor();
        if (exitCode == 0 && line != null) {
            return line.trim();
        }
        throw new IOException("Failed to retrieve hostname");
    }

    public static long getTotalMemoryBytes() {
        long totalMemoryBytes = 0L;
        try {
            totalMemoryBytes = ContainerdUtils.getTotalMemory();
        }
        catch (IOException e) {
            log.error("Error while retrieving total memory for container: " + String.valueOf(e));
        }
        return totalMemoryBytes;
    }

    private static long getTotalMemory() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("cat", "/proc/meminfo");
        Process process = processBuilder.start();
        try (InputStream inputStream = process.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("MemTotal:")) continue;
                String[] parts = line.split("\\s+");
                long l = Long.parseLong(parts[1]) * 1024L;
                return l;
            }
        }
        throw new IOException("Failed to retrieve total memory information.");
    }

    private static String formatBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static boolean isContainerdMonitoringSupportedOnCurrentOS() {
        return SystemUtils.IS_OS_LINUX;
    }
}

