/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.main;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentConfigDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.main.MainConfig;
import com.appdynamics.voltron.configuration.providers.UriConfigProviderModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import java.net.URI;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainConfigurationProviderModule
extends UriConfigProviderModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainConfigurationProviderModule.class);

    protected void configureMonitoredUris(Multibinder<URI> monitoredUriBinder) {
        monitoredUriBinder.addBinding().to(Key.get(URI.class, MainConfig.class));
    }

    protected void configurePollingPeriod(LinkedBindingBuilder<Long> bindPollingPeriod) {
        bindPollingPeriod.to(Key.get(Long.class, MainConfig.class));
    }

    @Provides
    @Singleton
    @MainConfig
    private URI provideConfigurationDirUri(@AgentConfigDir String configDir) {
        URI uri = Paths.get(configDir, new String[0]).toUri();
        log.debug("Monitoring configuration files in {}", (Object)uri);
        return uri;
    }

    @Provides
    @Singleton
    @MainConfig
    private Long provideConfigurationPollingPeriod(BootstrapConfiguration bootstrapConfiguration) {
        log.debug("Checking for configuration files every {} milliseconds", (Object)bootstrapConfiguration.getMainConfigUpdateIntervalMillis());
        return bootstrapConfiguration.getMainConfigUpdateIntervalMillis();
    }
}

