/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.model.ServerDto;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.kstruct.gethostname4j.Hostname;
import com.singularity.ee.util.system.SystemUtils;
import java.net.UnknownHostException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostnameProvider
implements Provider<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostnameProvider.class);
    public static final String APPDYNAMICS_HOST_NAME_RETRY_COUNT_PROP_NAME = "appdynamics.host.name.retry.count";
    public static final String APPDYNAMICS_HOST_NAME_FORCE_DNS_LOOKUP = "appdynamics.host.name.force.dns.lookup";
    private static final int DEFAULT_HOST_NAME_RETRY_COUNT = 5;
    public static final String APPDYNAMICS_HOST_NAME_RETRY_INTERVAL_IN_MILLIS_PROP_NAME = "appdynamics.host.name.retry.interval.in.millis";
    private static final long DEFAULT_HOST_NAME_RETRY_INTERVAL_IN_MILLIS = 1000L;
    private final BootstrapConfiguration configuration;
    private final Supplier<DockerService> dockerServiceSupplier;

    @Inject
    HostnameProvider(BootstrapConfiguration configuration, Supplier<DockerService> dockerService) {
        this.configuration = configuration;
        this.dockerServiceSupplier = dockerService;
    }

    public String get() {
        String hostname;
        block12: {
            hostname = null;
            if (this.configuration.getDockerEnabled().booleanValue()) {
                DockerService dockerService = (DockerService)this.dockerServiceSupplier.get();
                ServerDto serverInfo = dockerService.getServerInfo();
                log.debug("Retrieved Server Info: ", (Object)serverInfo);
                hostname = serverInfo.getName();
                if (hostname == null) {
                    throw new ProvisionException("Could not get the physical server host from Docker Engine");
                }
            } else {
                try {
                    hostname = SystemUtils.getLocalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    boolean forceDNSLookup = Boolean.getBoolean(APPDYNAMICS_HOST_NAME_FORCE_DNS_LOOKUP);
                    if (forceDNSLookup) {
                        int hostNameRetryCount = Integer.getInteger(APPDYNAMICS_HOST_NAME_RETRY_COUNT_PROP_NAME, 5);
                        long hostNameRetryIntervalInMillis = 1000L;
                        log.info("Host Name Retry Count " + hostNameRetryCount + " and Host Name Retry Interval in Millis " + hostNameRetryIntervalInMillis);
                        for (int i = 0; hostname == null && i < hostNameRetryCount; ++i) {
                            try {
                                hostname = SystemUtils.getLocalHostName();
                                continue;
                            }
                            catch (UnknownHostException e) {
                                log.warn("Encountered error while looking for local host name: " + String.valueOf(e) + " Will try for " + (hostNameRetryCount - i - 1) + " times more every " + hostNameRetryIntervalInMillis / 1000L + " seconds.");
                                try {
                                    Thread.sleep(hostNameRetryIntervalInMillis);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        log.info("Read Host Name: " + hostname + " after retying.");
                    } else {
                        log.info(" Attempting to read Host Name bypassing lookup.");
                        hostname = Hostname.getHostname();
                        log.info("Read Host Name: " + hostname + " bypassing lookup.");
                    }
                    if (hostname != null) break block12;
                    throw new ProvisionException("Could not resolve local hostname");
                }
            }
        }
        return hostname;
    }
}

