/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentConfigDir;
import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfigurationProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.ClearTextBootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.bootstrap.DefaultBootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.bootstrap.HostIdProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.HostnameProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineHierarchy;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineHierarchyProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineName;
import com.appdynamics.agent.sim.configuration.bootstrap.MachineNameProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.XmlMapperProvider;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.Hostname;
import com.appdynamics.voltron.utils.annotations.Raw;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;

public class BootstrapConfigurationModule
extends PrivateModule {
    static final String NAME_DEFAULT_XML_CONFIG = "defaultXmlConfigFile";
    static final String DEFAULT_XML_CONFIG = "controller-info.xml";
    static final String NAME_GLOBAL_XML_CONFIG = "defaultGlobalXmlConfigFile";
    private static final Key<String> AGENT_HOME_DIR_KEY = Key.get(String.class, AgentHomeDir.class);
    private static final Key<String> AGENT_CONFIG_DIR_KEY = Key.get(String.class, AgentConfigDir.class);
    private static final Key<String> AGENT_HOST_NAME_KEY = Key.get(String.class, Hostname.class);
    private static final Key<String> AGENT_HOST_ID_KEY = Key.get(String.class, HostId.class);
    private static final Key<String> AGENT_MACHINE_NAME_KEY = Key.get(String.class, MachineName.class);
    private static final Key<List<String>> AGENT_MACHINE_HIERARCHY_KEY = Key.get((TypeLiteral)new TypeLiteral<List<String>>(){}, MachineHierarchy.class);

    protected void configure() {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)NAME_DEFAULT_XML_CONFIG)).to(BootstrapConfigurationModule.getAgentConfigDir() + File.separatorChar + DEFAULT_XML_CONFIG);
        String globalConfigPath = BootstrapConfigurationModule.getGlobalConfigDir();
        if (globalConfigPath != null) {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)NAME_GLOBAL_XML_CONFIG)).to(globalConfigPath + File.separatorChar + DEFAULT_XML_CONFIG);
        } else {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)NAME_GLOBAL_XML_CONFIG)).to("");
        }
        this.bind(XmlMapper.class).toProvider(XmlMapperProvider.class).in(Scopes.SINGLETON);
        this.bind(BootstrapConfiguration.class).annotatedWith(Raw.class).toProvider(BootstrapConfigurationProvider.class).in(Scopes.SINGLETON);
        this.bind(BootstrapConfiguration.class).to(ClearTextBootstrapConfiguration.class).in(Scopes.SINGLETON);
        this.bind(AGENT_HOME_DIR_KEY).toInstance((Object)BootstrapConfigurationModule.getAgentHomeDir());
        this.bind(AGENT_CONFIG_DIR_KEY).toInstance((Object)BootstrapConfigurationModule.getAgentConfigDir());
        this.bind(AGENT_HOST_NAME_KEY).toProvider(HostnameProvider.class).in(Scopes.SINGLETON);
        this.bind(AGENT_HOST_ID_KEY).toProvider(HostIdProvider.class).in(Scopes.SINGLETON);
        this.bind(AGENT_MACHINE_NAME_KEY).toProvider(MachineNameProvider.class).in(Scopes.SINGLETON);
        this.bind(AGENT_MACHINE_HIERARCHY_KEY).toProvider(MachineHierarchyProvider.class).in(Scopes.SINGLETON);
        this.expose(BootstrapConfiguration.class);
        this.expose(BootstrapConfiguration.class).annotatedWith(Raw.class);
        this.expose(AGENT_HOME_DIR_KEY);
        this.expose(AGENT_CONFIG_DIR_KEY);
        this.expose(AGENT_HOST_NAME_KEY);
        this.expose(AGENT_HOST_ID_KEY);
        this.expose(AGENT_MACHINE_NAME_KEY);
        this.expose(AGENT_MACHINE_HIERARCHY_KEY);
        this.expose(XmlMapper.class);
        this.expose(String.class).annotatedWith((Annotation)Names.named((String)NAME_GLOBAL_XML_CONFIG));
    }

    @Provides
    @Singleton
    Validator provideValidator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public static String getAgentHomeDir() {
        String sysPropHomeDir = System.getProperty("singularity.install.dir");
        if (sysPropHomeDir == null || sysPropHomeDir.isEmpty()) {
            return BootstrapConfigurationModule.getAgentJarDir();
        }
        if (!new File(sysPropHomeDir).isDirectory()) {
            throw new IllegalStateException("The agent home dir specified via system property '" + sysPropHomeDir + "' does not exist or is not a directory. Please delete the file if it is a file and/or create the directory if it does not exist.");
        }
        return sysPropHomeDir;
    }

    private static String getAgentJarDir() {
        URL agentJarFileLocation = DefaultBootstrapConfiguration.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File jar = new File(agentJarFileLocation.toURI());
            return jar.getParentFile().getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Should not happen because the URL should be correct", e);
        }
    }

    public static String getAgentConfigDir() {
        return BootstrapConfigurationModule.getAgentHomeDir() + File.separatorChar + "conf";
    }

    private static String getGlobalConfigDir() {
        File globalHomeDir;
        File machineAgentHomeDir = new File(BootstrapConfigurationModule.getAgentHomeDir());
        File agentHomeDir = machineAgentHomeDir.getParentFile();
        if (agentHomeDir != null && (globalHomeDir = agentHomeDir.getParentFile()) != null) {
            File globalConfDirectory = new File(globalHomeDir, "conf");
            return globalConfDirectory.getAbsolutePath();
        }
        return null;
    }
}

