/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentConfigDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.StringUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import java.nio.file.Paths;

class TrustStorePathProvider
implements Provider<Optional<String>> {
    private final BootstrapConfiguration configuration;
    private final String agentConfDir;

    @Inject
    TrustStorePathProvider(BootstrapConfiguration configuration, @AgentConfigDir String agentConfDir) {
        this.configuration = configuration;
        this.agentConfDir = agentConfDir;
    }

    public Optional<String> get() {
        Object path = this.configuration.getTrustStorePath();
        if (!StringUtil.isBlank((String)path)) {
            File keyStoreFile;
            if (!Paths.get((String)path, new String[0]).isAbsolute()) {
                path = this.agentConfDir + File.separator + (String)path;
            }
            if ((keyStoreFile = new File((String)path)).canRead()) {
                return Optional.of((Object)path);
            }
            throw new ProvisionException("Cannot find or read the key store file " + keyStoreFile.getAbsolutePath());
        }
        File defaultKeyStoreFile = new File(this.agentConfDir, "cacerts.jks");
        if (defaultKeyStoreFile.exists()) {
            return Optional.of((Object)defaultKeyStoreFile.getAbsolutePath());
        }
        return Optional.absent();
    }
}

