/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.StringUtil;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

class SslProtocolProvider
implements Provider<String> {
    private final BootstrapConfiguration config;

    @Inject
    SslProtocolProvider(BootstrapConfiguration config) {
        this.config = config;
    }

    public String get() {
        String userSslProtocol = this.config.getSslProtocol();
        if (StringUtil.isBlank((String)userSslProtocol)) {
            return "TLSv1.2";
        }
        try {
            SSLContext.getInstance(userSslProtocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProvisionException("SSL protocol '" + userSslProtocol + "' specified by the user is not supported.", (Throwable)e);
        }
        return userSslProtocol;
    }
}

