/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.StringUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import java.nio.file.Paths;

class KeyStorePathProvider
implements Provider<Optional<String>> {
    private final BootstrapConfiguration configuration;
    private final String agentHomeDir;

    @Inject
    KeyStorePathProvider(BootstrapConfiguration configuration, @AgentHomeDir String agentHomeDir) {
        this.configuration = configuration;
        this.agentHomeDir = agentHomeDir;
    }

    public Optional<String> get() {
        Object path = this.configuration.getKeyStorePath();
        if (!StringUtil.isBlank((String)path)) {
            File keyStoreFile;
            if (!Paths.get((String)path, new String[0]).isAbsolute()) {
                path = this.agentHomeDir + File.separator + (String)path;
            }
            if ((keyStoreFile = new File((String)path)).canRead()) {
                return Optional.of((Object)path);
            }
            throw new ProvisionException("Cannot find or read the key store file " + keyStoreFile.getAbsolutePath());
        }
        return Optional.absent();
    }
}

