/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.singularity.ee.util.system.SystemUtils;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;

class KeyManagerFactoryProvider
implements Provider<KeyManagerFactory> {
    @Inject
    @VisibleForTesting
    KeyManagerFactoryProvider() {
    }

    public KeyManagerFactory get() {
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        String algorithm = SystemUtils.getProperty((String)"appdynamics.agent.ssl.keymanager.factory.algorithm", (String)defaultAlgorithm);
        try {
            return KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProvisionException("Could not find algorithm " + defaultAlgorithm, (Throwable)e);
        }
    }
}

