/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.rest.client.ProxyConfig;
import com.appdynamics.voltron.utils.StringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControllerProxyProvider
implements Provider<Optional<ProxyConfig>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerProxyProvider.class);
    private final BootstrapConfiguration bootstrapConfiguration;
    private final Optional<KeyStoreBasedEncryptionWrapper> encryptionWrapperOptional;

    @Inject
    public ControllerProxyProvider(BootstrapConfiguration bootstrapConfiguration, Optional<KeyStoreBasedEncryptionWrapper> encryptionWrapperOptional) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.encryptionWrapperOptional = encryptionWrapperOptional;
    }

    public Optional<ProxyConfig> get() {
        String host = this.bootstrapConfiguration.getProxyHost();
        if (host == null) {
            return Optional.absent();
        }
        Integer port = this.bootstrapConfiguration.getProxyPort();
        if (port == null) {
            throw new IllegalStateException("Proxy support is enabled but the port is missing.");
        }
        Optional<ProxyConfig.Auth> auth = this.getAuth();
        return Optional.of((Object)new ProxyConfig(host, port.intValue(), auth));
    }

    @VisibleForTesting
    Optional<ProxyConfig.Auth> getAuth() {
        String proxyPassword;
        String userName = this.bootstrapConfiguration.getProxyUsername();
        String passwordFile = this.bootstrapConfiguration.getProxyPasswordFile();
        if (StringUtil.isBlank((String)userName) || StringUtil.isBlank((String)passwordFile)) {
            return Optional.absent();
        }
        File proxyPasswordFile = new File(passwordFile);
        try {
            proxyPassword = FileUtil.readFirstLine((File)proxyPasswordFile);
        }
        catch (IOException ioe) {
            throw new ProvisionException("Unable to read proxy file from path: " + passwordFile);
        }
        if (proxyPassword == null) {
            log.warn("Unable to configure proxy, proxy password authentication is missing.");
            return Optional.absent();
        }
        if (this.encryptionWrapperOptional.isPresent()) {
            try {
                proxyPassword = ((KeyStoreBasedEncryptionWrapper)this.encryptionWrapperOptional.get()).decryptCipherTextString(proxyPassword);
            }
            catch (CryptoOperationFailureException e) {
                throw new ProvisionException("Failed to decrypt the proxy password.", (Throwable)e);
            }
        }
        boolean usePreemptive = this.bootstrapConfiguration.getProxyUsePreemptiveAuth();
        return Optional.of((Object)new ProxyConfig.Auth(userName, proxyPassword, usePreemptive));
    }
}

