/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.client;

import com.appdynamics.agent.sim.client.ControllerClientImplModule;
import com.appdynamics.agent.sim.client.ControllerProxyProvider;
import com.appdynamics.agent.sim.client.ControllerRetryer;
import com.appdynamics.agent.sim.client.ControllerSslModule;
import com.appdynamics.agent.sim.client.ControllerUrlProvider;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.rest.client.FeignClientBuilderModule;
import com.appdynamics.voltron.rest.client.ProxyConfig;
import com.google.common.base.Optional;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import feign.Client;
import feign.Retryer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class ControllerClientBuilderModule
extends FeignClientBuilderModule {
    public ControllerClientBuilderModule(String clientName) {
        super(clientName);
    }

    protected void configureBaseUrl(LinkedBindingBuilder<String> bindBaseUrl) {
        bindBaseUrl.toProvider(ControllerUrlProvider.class).in(Scopes.SINGLETON);
    }

    protected Module buildSslModule(Key<Optional<HostnameVerifier>> hostnameVerifierKey, Key<Optional<SSLContext>> sslContextKey) {
        return new ControllerSslModule(hostnameVerifierKey, sslContextKey);
    }

    protected void configureProxy(LinkedBindingBuilder<Optional<ProxyConfig>> bind) {
        bind.toProvider(ControllerProxyProvider.class).in(Scopes.SINGLETON);
    }

    protected void configureRetryer(LinkedBindingBuilder<Retryer> bind) {
        bind.to(ControllerRetryer.class);
    }

    protected Module buildClientImplModule(Key<Client> clientKey) {
        return new ControllerClientImplModule(clientKey);
    }

    @Provides
    @ControllerClientGzipEnabled
    private boolean provideGzipEnabled(BootstrapConfiguration bootstrapConfiguration) {
        return bootstrapConfiguration.getClientGzipEnabled();
    }

    protected void configureGzipCompression(LinkedBindingBuilder<Boolean> bindGzipEnabled) {
        bindGzipEnabled.to(Key.get(Boolean.TYPE, ControllerClientGzipEnabled.class));
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ControllerClientGzipEnabled {
    }
}

