/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim;

import com.appdynamics.agent.sim.assembler.AssemblyModule;
import com.appdynamics.agent.sim.client.ControllerClientModule;
import com.appdynamics.agent.sim.configuration.AgentConfigurationModule;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfigurationModule;
import com.appdynamics.agent.sim.configuration.main.MainConfigurationProviderModule;
import com.appdynamics.agent.sim.docker.DockerBootstrapModule;
import com.appdynamics.agent.sim.encryption.EncryptionModule;
import com.appdynamics.agent.sim.k8s.K8sLabelModule;
import com.appdynamics.agent.sim.log.Log4JFactoryModule;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLoggingModule;
import com.appdynamics.agent.sim.main.SecondStageModule;
import com.appdynamics.agent.sim.metadata.MachineMetadataModule;
import com.appdynamics.agent.sim.properties.MachinePropertiesModule;
import com.appdynamics.agent.sim.registration.RegistrationModule;
import com.appdynamics.agent.sim.scheduling.SchedulerModule;
import com.appdynamics.agent.sim.tags.MachineTagsModule;
import com.appdynamics.agent.sim.time.TimeModule;
import com.appdynamics.voltron.FrameworkApplication;
import com.appdynamics.voltron.FrameworkBootstrap;
import com.appdynamics.voltron.serialization.SimDtoSerializationModule;
import com.appdynamics.voltron.utils.overrides.OverriderModule;
import com.google.inject.CreationException;
import com.google.inject.Module;
import com.google.inject.spi.Message;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.validation.ConstraintViolationException;

public class Main
extends FrameworkApplication {
    private static final String STARTUP_LOG_FILE = "startup.log";
    Date date = new Date();
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void startSafe() {
        try {
            this.start();
        }
        catch (Throwable e) {
            if (e instanceof CreationException) {
                Message message = (Message)((CreationException)e).getErrorMessages().iterator().next();
                if (message.getCause() instanceof ConstraintViolationException || message.getCause() instanceof IOException) {
                    System.err.println(message.getCause().getLocalizedMessage());
                } else if (message.getCause() != null) {
                    this.handleUnknownException(message.getCause().getLocalizedMessage());
                } else {
                    this.handleUnknownException(message.getMessage());
                }
            } else {
                this.handleUnknownException(e.getLocalizedMessage());
            }
            System.err.println(" " + this.format.format(this.date) + " Please see startup.log in the current working directory for details.");
            try (PrintWriter pw = new PrintWriter(new FileOutputStream(STARTUP_LOG_FILE));){
                pw.println(new Date());
                e.printStackTrace(pw);
            }
            catch (IOException e2) {
                System.err.println(" " + this.format.format(this.date) + " Could not log exception details to startup file. Showing on the console instead.");
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private void handleUnknownException(String msg) {
        System.err.println(" " + this.format.format(this.date) + " Could not start up the machine agent due to: " + msg);
    }

    protected FrameworkBootstrap buildBootstrap() {
        return super.buildBootstrap().requireExplictBindings();
    }

    public Collection<Module> getApplicationModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)new Log4JFactoryModule());
        modules.add((Module)new OverriderModule());
        modules.add((Module)new BootstrapConfigurationModule());
        modules.add((Module)new SimAgentRepetitiveLoggingModule());
        modules.add((Module)new RegistrationModule());
        modules.add((Module)new ControllerClientModule());
        modules.add((Module)new TimeModule());
        modules.add((Module)new SchedulerModule());
        modules.add((Module)new MainConfigurationProviderModule());
        modules.add((Module)new SecondStageModule());
        modules.add((Module)new AgentConfigurationModule());
        modules.add((Module)new SimDtoSerializationModule());
        modules.add((Module)new EncryptionModule());
        modules.add((Module)new DockerBootstrapModule());
        modules.add((Module)new MachineMetadataModule());
        modules.add((Module)new MachinePropertiesModule());
        modules.add((Module)new MachineTagsModule());
        modules.add((Module)new K8sLabelModule());
        modules.add((Module)new AssemblyModule());
        return modules;
    }
}

