/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.appdynamics.voltron.rest.client.ssl.SslProtocol;
import com.appdynamics.voltron.rest.client.ssl.VoltronFeignSsl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslContextProvider
implements Provider<SSLContext> {
    private static final Logger log = LoggerFactory.getLogger(SslContextProvider.class);
    private final KeyManager keyManager;
    private final TrustManager trustManager;
    private final String protocol;

    @Inject
    SslContextProvider(@VoltronFeignSsl KeyManager keyManager, @VoltronFeignSsl TrustManager trustManager, @SslProtocol String protocol) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.protocol = protocol;
    }

    public SSLContext get() {
        try {
            SSLContext context = SSLContext.getInstance(this.protocol);
            context.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            String errorMsg = "Failed to initialize configure SSL for secure connections.";
            log.error(errorMsg, (Throwable)e);
            throw new ProvisionException(errorMsg, (Throwable)e);
        }
    }
}

