/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.ssl;

import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.ssl.ClientAuthentication;
import com.appdynamics.voltron.rest.client.ssl.ClientKeyAlias;
import com.appdynamics.voltron.rest.client.ssl.DefaultKeyManagerFactoryProvider;
import com.appdynamics.voltron.rest.client.ssl.FeignKeyStore;
import com.appdynamics.voltron.rest.client.ssl.FeignTrustStore;
import com.appdynamics.voltron.rest.client.ssl.FlexibleX509KeyManager;
import com.appdynamics.voltron.rest.client.ssl.FlexibleX509KeyManagerProvider;
import com.appdynamics.voltron.rest.client.ssl.FlexibleX509TrustManager;
import com.appdynamics.voltron.rest.client.ssl.FullChainValidation;
import com.appdynamics.voltron.rest.client.ssl.HostnameVerifierProvider;
import com.appdynamics.voltron.rest.client.ssl.KeyStoreLoader;
import com.appdynamics.voltron.rest.client.ssl.KeyStorePassword;
import com.appdynamics.voltron.rest.client.ssl.KeyStorePath;
import com.appdynamics.voltron.rest.client.ssl.KeyStorePrivateKeyPassword;
import com.appdynamics.voltron.rest.client.ssl.SslContextProvider;
import com.appdynamics.voltron.rest.client.ssl.SslProtocol;
import com.appdynamics.voltron.rest.client.ssl.TrustStorePassword;
import com.appdynamics.voltron.rest.client.ssl.TrustStorePath;
import com.appdynamics.voltron.rest.client.ssl.VoltronFeignSsl;
import com.google.common.base.Optional;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import lombok.NonNull;

public class FeignSslClientModule
extends PrivateModule {
    private final Key<Optional<HostnameVerifier>> hostnameVerifierKey;
    private final Key<Optional<SSLContext>> sslContextKey;

    public FeignSslClientModule(Key<Optional<HostnameVerifier>> hostnameVerifierKey, Key<Optional<SSLContext>> sslContextKey) {
        this.hostnameVerifierKey = hostnameVerifierKey;
        this.sslContextKey = sslContextKey;
    }

    public final void configure() {
        this.bind(HostnameVerifier.class).annotatedWith(VoltronFeignSsl.class).toProvider(HostnameVerifierProvider.class).in(Scopes.SINGLETON);
        this.bind(SSLContext.class).annotatedWith(VoltronFeignSsl.class).toProvider(SslContextProvider.class).in(Scopes.SINGLETON);
        this.configureTrustManager();
        this.configureKeyManager();
        this.configureSslProtocol((LinkedBindingBuilder<String>)this.bind(String.class).annotatedWith(SslProtocol.class));
        this.bind(this.hostnameVerifierKey).to(Key.get((TypeLiteral)new TypeLiteral<Optional<HostnameVerifier>>(){}, VoltronFeignSsl.class));
        this.bind(this.sslContextKey).to(Key.get((TypeLiteral)new TypeLiteral<Optional<SSLContext>>(){}, VoltronFeignSsl.class));
        this.expose(this.hostnameVerifierKey);
        this.expose(this.sslContextKey);
    }

    @Provides
    @VoltronFeignSsl
    private Optional<SSLContext> provideSslContext(@VoltronFeignSsl SSLContext sslContext) {
        return Optional.of((Object)sslContext);
    }

    @Provides
    @VoltronFeignSsl
    private Optional<HostnameVerifier> provideHostnameVerifier(@VoltronFeignSsl HostnameVerifier hostnameVerifier) {
        return Optional.of((Object)hostnameVerifier);
    }

    protected void configureTrustStorePath(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureTrustStorePassword(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureKeyStorePath(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureKeyStorePassword(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureKeyStorePrivateKeyPassword(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureKeyManagerFactory(LinkedBindingBuilder<KeyManagerFactory> bind) {
        bind.toProvider(DefaultKeyManagerFactoryProvider.class);
    }

    protected void configureClientAuthenticationEnabled(LinkedBindingBuilder<Boolean> bind) {
        bind.toInstance((Object)Boolean.FALSE);
    }

    protected void configureKeyStoreAlias(LinkedBindingBuilder<Optional<String>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    protected void configureFullChainValidationEnabled(LinkedBindingBuilder<Boolean> bind) {
        bind.toInstance((Object)Boolean.TRUE);
    }

    protected void configureSslProtocol(LinkedBindingBuilder<String> bind) {
        bind.toInstance((Object)"TLSv1.2");
    }

    private void configureTrustManager() {
        this.bind(TrustManager.class).annotatedWith(VoltronFeignSsl.class).to(FlexibleX509TrustManager.class).in(Scopes.SINGLETON);
        this.configureFullChainValidationEnabled((LinkedBindingBuilder<Boolean>)this.bind(Boolean.class).annotatedWith(FullChainValidation.class));
        this.configureTrustStorePath((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(TrustStorePath.class));
        this.configureTrustStorePassword((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(TrustStorePassword.class));
    }

    private void configureKeyManager() {
        this.configureKeyManagerFactory((LinkedBindingBuilder<KeyManagerFactory>)this.bind(KeyManagerFactory.class).annotatedWith(FeignKeyStore.class));
        this.bind(X509KeyManager.class).annotatedWith(VoltronFeign.class).toProvider(FlexibleX509KeyManagerProvider.class).in(Scopes.SINGLETON);
        this.bind(KeyManager.class).annotatedWith(VoltronFeignSsl.class).to(FlexibleX509KeyManager.class).in(Scopes.SINGLETON);
        this.configureClientAuthenticationEnabled((LinkedBindingBuilder<Boolean>)this.bind((TypeLiteral)new TypeLiteral<Boolean>(){}).annotatedWith(ClientAuthentication.class));
        this.configureKeyStorePath((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(KeyStorePath.class));
        this.configureKeyStorePassword((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(KeyStorePassword.class));
        this.configureKeyStorePrivateKeyPassword((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(KeyStorePrivateKeyPassword.class));
        this.configureKeyStoreAlias((LinkedBindingBuilder<Optional<String>>)this.bind((TypeLiteral)new TypeLiteral<Optional<String>>(){}).annotatedWith(ClientKeyAlias.class));
    }

    @Provides
    @FeignTrustStore
    @Singleton
    KeyStoreLoader provideKeyStoreLoaderForTrustStore(@TrustStorePath @NonNull Optional<String> keyStorePath, @TrustStorePassword @NonNull Optional<String> keyStorePassword) {
        if (keyStorePath == null) {
            throw new NullPointerException("keyStorePath is marked non-null but is null");
        }
        if (keyStorePassword == null) {
            throw new NullPointerException("keyStorePassword is marked non-null but is null");
        }
        return new KeyStoreLoader(keyStorePath, keyStorePassword);
    }

    @Provides
    @FeignTrustStore
    @Singleton
    Optional<KeyStore> provideTrustStore(@FeignTrustStore @NonNull KeyStoreLoader keyStoreLoader) {
        if (keyStoreLoader == null) {
            throw new NullPointerException("keyStoreLoader is marked non-null but is null");
        }
        return keyStoreLoader.read();
    }

    @Provides
    @FeignKeyStore
    @Singleton
    KeyStoreLoader provideKeyStoreLoaderForKeyStore(@KeyStorePath @NonNull Optional<String> keyStorePath, @KeyStorePassword @NonNull Optional<String> keyStorePassword) {
        if (keyStorePath == null) {
            throw new NullPointerException("keyStorePath is marked non-null but is null");
        }
        if (keyStorePassword == null) {
            throw new NullPointerException("keyStorePassword is marked non-null but is null");
        }
        return new KeyStoreLoader(keyStorePath, keyStorePassword);
    }

    @Provides
    @FeignKeyStore
    @Singleton
    Optional<KeyStore> provideKeyStore(@FeignKeyStore @NonNull KeyStoreLoader keyStoreLoader) {
        if (keyStoreLoader == null) {
            throw new NullPointerException("keyStoreLoader is marked non-null but is null");
        }
        return keyStoreLoader.read();
    }
}

