/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.urlconn;

import com.appdynamics.voltron.rest.client.ProxyConfig;
import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.impl.urlconn.BasicSchemeAuthentication;
import com.appdynamics.voltron.rest.client.impl.urlconn.UrlConnClientImpl;
import com.appdynamics.voltron.rest.client.impl.urlconn.UrlConnProxyConfig;
import com.google.common.base.Optional;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import feign.Client;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class UrlConnectionClientModule
extends PrivateModule {
    private final Key<Client> clientKey;

    public UrlConnectionClientModule(Key<Client> clientKey) {
        this.clientKey = clientKey;
    }

    protected void configure() {
        this.bind(this.clientKey).to(UrlConnClientImpl.class);
        this.bind(BasicSchemeAuthentication.class);
        this.expose(this.clientKey);
    }

    @Provides
    private UrlConnProxyConfig provideUrlConnProxyConfig(@VoltronFeign Optional<ProxyConfig> proxyConfigOpt, BasicSchemeAuthentication scheme) {
        if (!proxyConfigOpt.isPresent()) {
            return UrlConnProxyConfig.NO_PROXY_CONFIG;
        }
        ProxyConfig proxyConfig = (ProxyConfig)proxyConfigOpt.get();
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHostname(), proxyConfig.getPort()));
        Optional authOpt = Optional.absent();
        if (proxyConfig.getAuth().isPresent()) {
            ProxyConfig.Auth proxyAuth = (ProxyConfig.Auth)proxyConfig.getAuth().get();
            authOpt = Optional.of((Object)scheme.create(proxyAuth.getUsername(), proxyAuth.getPassword()));
        }
        return new UrlConnProxyConfig(proxy, (Optional<String>)authOpt);
    }
}

