/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.urlconn;

import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.VoltronFeignGzip;
import com.appdynamics.voltron.rest.client.impl.urlconn.UrlConnProxyConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

class UrlConnClientImpl
implements Client {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostnameVerifier> hostnameVerifier;
    private final boolean gzipEncodedRequest;
    private final UrlConnProxyConfig proxyConfig;
    private static final String PROXY_AUTHENTICATION_HEADER = "Proxy-Authorization";
    private static final int CONTENT_CHUNK_SIZE = 8196;

    @Inject
    UrlConnClientImpl(@VoltronFeign Optional<SSLContext> sslContext, @VoltronFeign Optional<HostnameVerifier> hostnameVerifier, @VoltronFeignGzip boolean gzipEncodedRequest, UrlConnProxyConfig proxyConfig) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.gzipEncodedRequest = gzipEncodedRequest;
        this.proxyConfig = proxyConfig;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpURLConnection connection = this.convertAndSend(request, options);
        Response response = this.convertResponse(request, connection);
        Collection encodingVals = (Collection)response.headers().get("Content-Encoding");
        if (encodingVals != null) {
            for (String encoding : encodingVals) {
                if (!encoding.equalsIgnoreCase("gzip")) continue;
                GZIPInputStream inputStream = new GZIPInputStream(response.body().asInputStream());
                return Response.builder().request(request).status(response.status()).reason(response.reason()).headers(response.headers()).body((InputStream)inputStream, null).build();
            }
        }
        return response;
    }

    private HttpURLConnection createConnectionWithProxy(Request request) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(request.url()).openConnection(this.proxyConfig.getProxy());
        if (this.proxyConfig.getProxyAuth().isPresent()) {
            connection.setRequestProperty(PROXY_AUTHENTICATION_HEADER, (String)this.proxyConfig.getProxyAuth().get());
        }
        return connection;
    }

    private HttpURLConnection convertAndSend(Request request, Request.Options options) throws IOException {
        HttpURLConnection connection = this.createConnectionWithProxy(request);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            if (this.sslContext.isPresent()) {
                sslCon.setSSLSocketFactory(((SSLContext)this.sslContext.get()).getSocketFactory());
            }
            if (this.hostnameVerifier.isPresent()) {
                sslCon.setHostnameVerifier((HostnameVerifier)this.hostnameVerifier.get());
            }
        }
        connection.setConnectTimeout(options.connectTimeoutMillis());
        connection.setReadTimeout(options.readTimeoutMillis());
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod(request.httpMethod().name());
        Integer contentLength = null;
        for (String field : request.headers().keySet()) {
            for (String value : (Collection)request.headers().get(field)) {
                if (field.equals("Content-Length")) {
                    if (this.gzipEncodedRequest) continue;
                    contentLength = Integer.valueOf(value);
                    connection.addRequestProperty(field, value);
                    continue;
                }
                connection.addRequestProperty(field, value);
            }
        }
        if (request.body() != null && request.body().length != 0) {
            if (this.gzipEncodedRequest) {
                connection.setRequestProperty("Content-Encoding", "gzip");
            }
            if (contentLength != null) {
                connection.setFixedLengthStreamingMode(contentLength);
            } else {
                connection.setChunkedStreamingMode(8196);
            }
            connection.setDoOutput(true);
            try (OutputStream out = this.extractOutputStream(connection);){
                out.write(request.body());
            }
        }
        return connection;
    }

    private OutputStream extractOutputStream(HttpURLConnection connection) throws IOException {
        OutputStream out = connection.getOutputStream();
        if (this.gzipEncodedRequest) {
            return new GZIPOutputStream(out);
        }
        return out;
    }

    private Response convertResponse(Request request, HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        String reason = connection.getResponseMessage();
        LinkedHashMap<String, Collection> headers = new LinkedHashMap<String, Collection>();
        for (Map.Entry<String, List<String>> field : connection.getHeaderFields().entrySet()) {
            if (field.getKey() == null) continue;
            headers.put(field.getKey(), field.getValue());
        }
        Integer length = connection.getContentLength();
        if (length == -1) {
            length = null;
        }
        InputStream stream = status >= 400 ? connection.getErrorStream() : connection.getInputStream();
        return Response.builder().request(request).status(status).reason(reason).headers(headers).body(stream, length).build();
    }
}

